/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import java.awt.Point;

public class PointCustomizer
extends AbstractCustomizer<Point, NumericalSliderComponent[]> {
    private NumericalSliderComponent x = this.getSlider("&X", 0);
    private NumericalSliderComponent y = this.getSlider("&Y", 0);

    public PointCustomizer() {
        super(new VerticalFlowLayout(0));
        this.add(this.x);
        this.add(this.y);
        this.setEditor(new NumericalSliderComponent[]{this.x, this.y});
    }

    public PointCustomizer(Point point) {
        this();
        this.setPoint(point);
    }

    public Point getPoint() {
        return (Point)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setPoint((Point)bean);
    }

    public void setPoint(Point point) {
        this.x.setValue(point.x);
        this.y.setValue(point.y);
        super.setObject(point);
    }

    private NumericalSliderComponent getSlider(String label, int value) {
        NumericalSliderComponent c = new NumericalSliderComponent(label, value, 0, 2000, 1);
        c.getLabel().setPreferredSize(50, 23);
        new PropertyChangeInvoker(c, this, "pointChanged");
        return c;
    }

    @Reflected
    private void pointChanged() {
        Point point = new Point((Point)this.getObject());
        point.x = (int)this.x.getValue();
        point.y = (int)this.y.getValue();
        this.setObject(point);
    }
}

