/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import java.beans.Customizer;
import java.util.HashMap;

public class PropertyEditorFactory {
    private HashMap<Class<?>, Class<? extends Customizer>> editors = new HashMap();
    private boolean returnCompatibleEditor;

    public PropertyEditorFactory() {
        this.setReturnCompatibleEditor(false);
    }

    public void setEditor(Class<?> type, Class<? extends Customizer> editorType) {
        this.editors.put(type, editorType);
    }

    public Customizer getEditor(Class<?> type) {
        Class<? extends Customizer> editorType = this.editors.get(type);
        if (editorType == null && this.returnCompatibleEditor) {
            for (Class<?> key : this.editors.keySet()) {
                if (!key.isAssignableFrom(type)) continue;
                editorType = this.editors.get(key);
            }
        }
        return PropertyEditorFactory.createCustomizer(editorType);
    }

    private static Customizer createCustomizer(Class<? extends Customizer> editorType) {
        try {
            Customizer customizer = editorType.newInstance();
            return customizer;
        }
        catch (Exception e) {
            System.out.println("PropertyEditorFactory.createCustomizer(" + editorType.getName() + ") cannot be instantiatedwith newInstance().  All customizers must have a no argument constructor.");
            return null;
        }
    }

    public Customizer getEditor(Class<?> type, Object value) {
        Customizer c = this.getEditor(type);
        if (c != null) {
            c.setObject(value);
        }
        return c;
    }

    public boolean isReturnCompatibleEditor() {
        return this.returnCompatibleEditor;
    }

    public void setReturnCompatibleEditor(boolean returnCompatibleEditor) {
        this.returnCompatibleEditor = returnCompatibleEditor;
    }
}

