/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import java.awt.Rectangle;

public class RectangleCustomizer
extends AbstractCustomizer<Rectangle, NumericalSliderComponent[]> {
    private NumericalSliderComponent x = this.getSlider("&X", 0);
    private NumericalSliderComponent y = this.getSlider("&Y", 0);
    private NumericalSliderComponent width = this.getSlider("&Width", 0);
    private NumericalSliderComponent height = this.getSlider("&Height", 0);

    public RectangleCustomizer() {
        super(new VerticalFlowLayout(0));
        this.add(this.x);
        this.add(this.y);
        this.add(this.width);
        this.add(this.height);
        this.setEditor(new NumericalSliderComponent[]{this.x, this.y, this.width, this.height});
    }

    public RectangleCustomizer(Rectangle rectangle) {
        this();
        this.setRectangle(rectangle);
    }

    public Rectangle getRectangle() {
        return (Rectangle)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setRectangle((Rectangle)bean);
    }

    public void setRectangle(Rectangle rectangle) {
        this.x.setValue(rectangle.x);
        this.y.setValue(rectangle.y);
        this.width.setValue(rectangle.width);
        this.height.setValue(rectangle.height);
        super.setObject(rectangle);
    }

    private NumericalSliderComponent getSlider(String label, int value) {
        NumericalSliderComponent c = new NumericalSliderComponent(label, value, 0, 1000, 1);
        c.getLabel().setPreferredSize(50, 23);
        new PropertyChangeInvoker(c, this, "createNewRectangle");
        return c;
    }

    @Reflected
    private void createNewRectangle() {
        Rectangle rect = new Rectangle((int)this.x.getValue(), (int)this.y.getValue(), (int)this.width.getValue(), (int)this.height.getValue());
        this.setObject(rect);
    }
}

