/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.graphics.drawing.PaperDrawer;
import com.jmorgan.swing.decorator.PaperDecorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;

public class CopyDecorator
extends PaperDecorator {
    public CopyDecorator() {
        super(6);
    }

    public CopyDecorator(int padding) {
        super(padding, new Color(110, 145, 210), Color.BLACK);
    }

    public CopyDecorator(int padding, Color edgeColor, Color textColor) {
        super(padding, edgeColor, textColor);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        Color edgeColor = this.getEdgeColor();
        Color textColor = this.getTextColor();
        int padding = this.getPadding();
        Point location = new Point(padding, padding);
        int doublePad = padding * 2;
        int forthWidth = size.width / 4;
        int forthHeight = size.height / 4;
        Dimension paperSize = new Dimension(size.width - doublePad - forthWidth, size.height - doublePad - forthHeight);
        PaperDrawer drawer = new PaperDrawer(location, paperSize, edgeColor, textColor);
        drawer.draw(g);
        location.x += forthWidth;
        location.y += forthHeight;
        drawer.setLocation(location);
        drawer.draw(g);
    }
}

