/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.graphics.drawing.PrinterDrawer;
import com.jmorgan.swing.decorator.IconDecorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JComponent;

public class PrinterDecorator
extends IconDecorator {
    private Color textColor;
    private Color edgeColor;
    private Color printerColor;

    public PrinterDecorator() {
        this(6, Color.black, Color.black, Color.LIGHT_GRAY);
    }

    public PrinterDecorator(int padding, Color textColor, Color edgeColor, Color printerColor) {
        super(padding);
        this.setEdgeColor(edgeColor);
        this.setTextColor(textColor);
        this.setPrinterColor(printerColor);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getPrinterColor() {
        return this.printerColor;
    }

    public void setPrinterColor(Color printerColor) {
        this.printerColor = printerColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        int padding = this.getPadding();
        int doublePad = padding * 2;
        Point location = new Point(padding, padding);
        Dimension pSize = new Dimension(size.width - doublePad - 1, size.height - doublePad - 1);
        PrinterDrawer printerDrawer = new PrinterDrawer(location, pSize, this.edgeColor, this.textColor, this.printerColor);
        printerDrawer.draw(g);
    }
}

