/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.dialog.uiconstants;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyBinder;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.customizer.FontCustomizer;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.dialog.uiconstants.AbstractUIResourcePanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class FontEditorPanel
extends AbstractUIResourcePanel
implements DialogPanel {
    private FontCustomizer fontEditor;
    private Font font;
    private boolean ignoreChanges;
    private GenericDialog parentDialog;

    public FontEditorPanel() {
        this.setLayout(new BorderLayout(5, 5));
        this.ignoreChanges = false;
        this.fontEditor = new FontCustomizer();
        this.add((Component)this.fontEditor, "Center");
    }

    public FontEditorPanel(Font initialFont) {
        this.setLayout(new BorderLayout(5, 5));
        this.ignoreChanges = false;
        this.fontEditor = new FontCustomizer(initialFont);
        this.add((Component)this.fontEditor, "Center");
    }

    @Override
    public void setPropertyName(String propertyName) {
        super.setPropertyName(propertyName);
        this.fontEditor.setPropertyName(propertyName);
        new PropertyBinder(this.fontEditor, propertyName, this, "fontValue");
    }

    @Override
    public void setUIResource(Object uiResource) {
        super.setUIResource(uiResource);
        this.font = (Font)uiResource;
        this.ignoreChanges = true;
        this.fontEditor.setFont(this.font);
        this.ignoreChanges = false;
    }

    @Reflected
    public void setFontValue(Font font) {
        PropertyChangeListener[] pcls;
        if (this.ignoreChanges) {
            return;
        }
        UIManager.put(this.getPropertyName(), new FontUIResource(font));
        Font oldFont = this.font;
        this.font = font;
        if (oldFont == null || oldFont.equals(this.font)) {
            return;
        }
        String propertyName = this.getPropertyName();
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldFont, font);
        PropertyChangeListener[] propertyChangeListenerArray = pcls = this.getPropertyChangeListeners();
        int n = pcls.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener pcl = propertyChangeListenerArray[n2];
            pcl.propertyChange(event);
            ++n2;
        }
    }

    public Font getFontValue() {
        return this.font;
    }

    @Override
    public void setParentDialog(GenericDialog dialog) {
        this.parentDialog = dialog;
        if (dialog != null) {
            this.parentDialog.setCancelled(true);
            JMButton okButton = new JMButton("OK");
            new ActionEventInvoker(okButton, this, "commitFont");
            JMButton cancelButton = new JMButton("Cancel");
            new ActionEventInvoker(cancelButton, dialog, "closeDialog");
            JMPanel buttonPanel = new JMPanel();
            buttonPanel.addAll(okButton, cancelButton);
            this.add((Component)buttonPanel, "South");
        }
    }

    @Reflected
    private void commitFont() {
        this.parentDialog.setCancelled(false);
        this.font = this.fontEditor.getFontValue();
        this.parentDialog.closeDialog();
    }

    @Override
    public boolean parentDialogClosing() {
        return true;
    }
}

