/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.dialog.uiconstants;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.MainPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.uiconstants.AbstractUIResourcePanel;
import com.jmorgan.swing.dialog.uiconstants.UIResourcePanelFactory;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.layout.EditorLayout;
import com.jmorgan.swing.list.ListModelFactory;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.collection.ListNotUniqueException;
import com.jmorgan.util.collection.UniqueArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class UIConstantsDialog
extends JMDialog {
    private HashMap<String, Object> data;
    private JMList<String> propertyKeyList;
    private JMPanel uiPanel;
    private EditorLayout uiLayout;

    public UIConstantsDialog() {
        this((JFrame)null);
    }

    public UIConstantsDialog(JFrame owner) {
        this(owner, "Set UI Constants");
    }

    public UIConstantsDialog(JFrame owner, String title) {
        super(owner, title);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        MainPanel mainPanel = new MainPanel();
        this.uiLayout = new EditorLayout();
        this.uiPanel = new JMPanel(this.uiLayout);
        this.data = this.getData();
        this.propertyKeyList = new JMList(ListModelFactory.createListModel(this.getDataKeys()));
        new ListSelectionEventInvoker(this.propertyKeyList, this, "propertySelectionChanged");
        mainPanel.add((Component)new JMScrollPane(this.propertyKeyList), "West");
        mainPanel.add((Component)this.uiPanel, "Center");
        this.contentPane.add((Component)mainPanel, "Center");
        this.contentPane.add((Component)this.createButtonPanel(), "South");
        this.setPreferredSize(new Dimension(800, 500));
        new AsynchMethodInvoker((Object)this.propertyKeyList, "setSelectedIndex", (Object)0, 100);
    }

    private HashMap<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        for (Object key : uiDefaults.keySet()) {
            if (key.toString().contains("font") || key.toString().contains("Font")) {
                System.out.println("UIConstantsDialog.getData() Key type is: " + String.valueOf(key) + "=>" + key.getClass().getName());
            }
            data.put(key.toString(), UIManager.get(key));
        }
        return data;
    }

    private ArrayList<String> getDataKeys() {
        UniqueArrayList<String> dataKeys = new UniqueArrayList<String>(this.data.keySet());
        try {
            dataKeys.setUniqueAssurancePolicy(false);
            Collections.sort(dataKeys);
            dataKeys.setUniqueAssurancePolicy(true);
        }
        catch (ListNotUniqueException e) {
            e.printStackTrace();
        }
        return dataKeys;
    }

    private JMPanel createButtonPanel() {
        JMPanel panel = new JMPanel();
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        panel.add(ComponentFactory.createButton(null, "&OK", null, true, this, "okClicked", new Object[0]));
        panel.add(ComponentFactory.createButton(null, "&Apply", null, true, this, "applyClicked", new Object[0]));
        panel.add(ComponentFactory.createButton(null, "&Cancel", null, true, this, "cancelClicked", new Object[0]));
        return panel;
    }

    public void propertySelectionChanged() {
        String propertyName = (String)this.propertyKeyList.getSelectedValue();
        Object uiResource = UIManager.get(propertyName);
        if (uiResource == null) {
            return;
        }
        AbstractUIResourcePanel panel = UIResourcePanelFactory.getUIResourcePanel(propertyName, uiResource);
        if (!this.uiLayout.containsCard(propertyName)) {
            this.uiPanel.add((Component)panel, propertyName);
        }
        this.uiLayout.show(this.uiPanel, propertyName);
        this.repaint();
    }

    public void okClicked() {
        this.applyClicked();
        WindowCloser.closeWindow(this);
    }

    public void applyClicked() {
        SwingUtilities.updateComponentTreeUI(this);
        SwingUtilities.updateComponentTreeUI(GUIApplication.getGUIApplication().getApplicationFrame());
    }

    public void cancelClicked() {
        WindowCloser.closeWindow(this);
    }
}

