/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import com.jmorgan.swing.layout.AbstractLayout;
import com.jmorgan.swing.layout.CellLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class CellLayout
extends AbstractLayout {
    private Hashtable<Component, CellLayoutConstraints> constraints = new Hashtable();
    private int minimumRows = 0;
    private int minimumColumns = 0;
    private int hGap = 0;
    private int vGap = 0;

    public CellLayout() {
    }

    public CellLayout(int hGap, int vGap) {
        this();
        this.hGap = hGap;
        this.vGap = vGap;
    }

    public CellLayout(int rows, int columns, int hGap, int vGap) {
        this(hGap, vGap);
        this.minimumRows = rows;
        this.minimumColumns = columns;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    private Dimension[][] getCellGrid(Container parent) {
        Dimension[][] cells = new Dimension[this.getGridRowCount(parent)][this.getGridColumnCount(parent)];
        int i = 0;
        while (i < cells.length) {
            int j = 0;
            while (j < cells[i].length) {
                cells[i][j] = new Dimension(0, 0);
                ++j;
            }
            ++i;
        }
        return cells;
    }

    public int getGridRowCount(Container parent) {
        return this.minimumRows;
    }

    public int getGridColumnCount(Container parent) {
        return this.minimumColumns;
    }

    private Dimension getLayoutSize(Container parent, int sizeType) {
        JComponent panel;
        Border border;
        int j;
        Dimension dim = new Dimension(0, 0);
        Dimension[][] cell = this.getCellGrid(parent);
        Component[] comp = parent.getComponents();
        int i = 0;
        while (i < comp.length) {
            Dimension d = null;
            CellLayoutConstraints loc = this.constraints.get(comp[i]);
            switch (sizeType) {
                case 1: {
                    d = comp[i].getMinimumSize();
                    break;
                }
                case 2: {
                    d = comp[i].getMaximumSize();
                    break;
                }
                default: {
                    d = comp[i].getPreferredSize();
                }
            }
            j = loc.cellRow;
            int jl = loc.cellRow + loc.vertCells;
            while (j < jl) {
                int k = loc.cellColumn;
                int kl = loc.cellColumn + loc.horzCells;
                while (k < kl) {
                    cell[j][k].width = d.width / loc.horzCells;
                    cell[j][k].height = d.height / loc.vertCells;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int[] row = new int[this.getGridRowCount(parent)];
        int[] col = new int[this.getGridColumnCount(parent)];
        int i2 = 0;
        while (i2 < cell.length) {
            j = 0;
            while (j < cell[i2].length) {
                if (row[i2] < cell[i2][j].height) {
                    row[i2] = cell[i2][j].height;
                }
                if (col[j] < cell[i2][j].width) {
                    col[j] = cell[i2][j].width;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < row.length) {
            dim.height += row[i2];
            ++i2;
        }
        if (row.length < this.minimumRows) {
            float avgRowHeight = (float)dim.height / (float)row.length;
            int emptyRows = this.minimumRows - row.length;
            int emptyHeight = (int)((float)emptyRows * avgRowHeight);
            dim.height += emptyHeight;
        }
        i = 0;
        while (i < col.length) {
            dim.width += col[i];
            ++i;
        }
        if (col.length < this.minimumColumns) {
            float avgColWidth = (float)dim.width / (float)col.length;
            int emptyCols = this.minimumColumns - col.length;
            int emptyWidth = (int)((float)emptyCols * avgColWidth);
            dim.width += emptyWidth;
        }
        if (parent instanceof JComponent && (border = (panel = (JComponent)parent).getBorder()) != null) {
            Insets borderInsets = border.getBorderInsets(panel);
            dim.width += borderInsets.left + borderInsets.right;
            dim.height += borderInsets.top + borderInsets.bottom;
        }
        Insets i22 = parent.getInsets();
        dim.width += i22.left + i22.right + (col.length - 1) * this.hGap;
        dim.height += i22.top + i22.bottom + (row.length - 1) * this.vGap;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        int nCols;
        Dimension dim = parent.getSize();
        Insets inset = parent.getInsets();
        Insets borderInsets = this.getBorderInsets(parent);
        int nRows = this.getGridRowCount(parent);
        if (nRows == 0) {
            nRows = 1;
        }
        if ((nCols = this.getGridColumnCount(parent)) == 0) {
            nCols = 1;
        }
        int rowHeight = (dim.height - inset.top - inset.bottom - borderInsets.top - borderInsets.bottom - (nRows - 1) * this.vGap) / nRows;
        int colWidth = (dim.width - inset.left - inset.right - borderInsets.left - borderInsets.right - (nCols - 1) * this.hGap) / nCols;
        Component[] comp = parent.getComponents();
        int i = 0;
        while (i < comp.length) {
            CellLayoutConstraints loc = this.constraints.get(comp[i]);
            int x = inset.left + borderInsets.left + loc.cellColumn * (colWidth + this.hGap);
            int y = inset.top + borderInsets.top + loc.cellRow * (rowHeight + this.vGap);
            int w = loc.horzCells * colWidth + (loc.horzCells - 1) * this.hGap;
            int h = loc.vertCells * rowHeight + (loc.vertCells - 1) * this.vGap;
            comp[i].setBounds(x, y, w, h);
            ++i;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 2);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    public void setConstraints(Component c, CellLayoutConstraints loc) {
        CellLayoutConstraints copy = this.constraints.containsValue(loc) ? new CellLayoutConstraints(loc) : loc;
        this.constraints.put(c, copy);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) throws IllegalArgumentException, UnsupportedOperationException {
        int maxRow;
        if (constraints == null) {
            if (this.constraints.containsKey(comp)) {
                return;
            }
            throw new UnsupportedOperationException("To use java.awt.Container.add(Component), call CellLayout.setConstraints() first, otherwise, use java.awt.Container.add(Component, Object)");
        }
        if (!(constraints instanceof CellLayoutConstraints)) {
            throw new IllegalArgumentException("Constraints must be an instance of CellLayoutConstraints");
        }
        CellLayoutConstraints c = (CellLayoutConstraints)constraints;
        int maxCol = c.getMaxHorizontalCell();
        if (maxCol > this.minimumColumns) {
            this.minimumColumns = maxCol;
        }
        if ((maxRow = c.getMaxVerticalCell()) > this.minimumRows) {
            this.minimumRows = maxRow;
        }
        this.setConstraints(comp, c);
    }
}

