/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import com.jmorgan.swing.util.ContainerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalFlowLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    public static final int BOTH = 3;
    private int justification;
    private int vGap;

    public VerticalFlowLayout() {
        this(2, 5);
    }

    public VerticalFlowLayout(int justification) {
        this(justification, 5);
    }

    public VerticalFlowLayout(int justification, int vGap) {
        this.setJustification(justification);
        this.setvGap(vGap);
    }

    public int getJustification() {
        return this.justification;
    }

    public void setJustification(int justification) {
        switch (justification) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.justification = justification;
            }
        }
    }

    public int getvGap() {
        return this.vGap;
    }

    public void setvGap(int vGap) {
        this.vGap = vGap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] comp = parent.getComponents();
        int[] yLocations = this.getComponentY(comp, 0);
        Insets insets = parent.getInsets();
        int parentWidth = parent.getWidth();
        int widestComponent = ContainerService.getWidestComponent(comp);
        if (widestComponent > parentWidth) {
            Dimension parentSize = parent.getSize();
            parentSize.width = widestComponent + insets.left + insets.right;
            parent.setPreferredSize(parentSize);
            parent.setSize(parentSize);
            parentWidth = parentSize.width;
        }
        int halfParentWidth = parentWidth / 2;
        int x = 0;
        int i = 0;
        while (i < comp.length) {
            if (comp[i] != null && comp[i].isVisible()) {
                Dimension compSize = comp[i].getPreferredSize();
                int w = compSize.width;
                switch (this.justification) {
                    case 0: {
                        x = insets.left;
                        break;
                    }
                    case 2: {
                        x = halfParentWidth - compSize.width / 2;
                        break;
                    }
                    case 1: {
                        x = parentWidth - (insets.right + compSize.width);
                        break;
                    }
                    case 3: {
                        x = insets.left;
                        w = parentWidth - insets.left - insets.right;
                    }
                }
                comp[i].setBounds(x, yLocations[i], w, compSize.height);
            }
            ++i;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.getSize(parent, 1);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.getSize(parent, 0);
    }

    private Dimension getSize(Container parent, int sizeType) {
        Dimension size = new Dimension();
        Component[] comp = parent.getComponents();
        int[] yLocations = this.getComponentY(comp, sizeType);
        int i = 0;
        while (i < comp.length) {
            if (comp[i] != null && comp[i].isVisible()) {
                Dimension compSize = switch (sizeType) {
                    case 1 -> comp[i].getMinimumSize();
                    case 2 -> comp[i].getMaximumSize();
                    case 0 -> comp[i].getPreferredSize();
                    default -> size;
                };
                int w = compSize.width + comp[i].getX();
                int h = compSize.height + yLocations[i];
                if (size.width < w) {
                    size.width = w;
                }
                if (size.height < h) {
                    size.height = h;
                }
            }
            ++i;
        }
        Insets insets = parent.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.bottom;
        return size;
    }

    private int[] getComponentY(Component[] comp, int sizeType) {
        if (comp.length == 0) {
            return new int[0];
        }
        Dimension size = new Dimension();
        int[] yLocations = new int[comp.length];
        int y = comp[0].getParent().getInsets().top;
        int i = 0;
        while (i < comp.length) {
            if (comp[i] != null && comp[i].isVisible()) {
                yLocations[i] = y;
                Dimension compSize = switch (sizeType) {
                    case 1 -> comp[i].getMinimumSize();
                    case 2 -> comp[i].getMaximumSize();
                    case 0 -> comp[i].getPreferredSize();
                    default -> size;
                };
                y += compSize.height + this.vGap;
            }
            ++i;
        }
        return yLocations;
    }

    @Override
    public void removeLayoutComponent(Component parent) {
    }
}

