/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.list.ListCellEditor;
import java.awt.Component;
import javax.swing.JList;

public class DefaultListCellEditor
extends JMTextField
implements ListCellEditor {
    private String propertyName;
    private Object lastValue;
    private String nullValueDisplay;

    public DefaultListCellEditor(String propertyName) {
        this.setPropertyName(propertyName);
        this.setNullValueDisplay("-null-");
        new PropertyChangeInvoker(this, this, "textChanged");
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getNullValueDisplay() {
        return this.nullValueDisplay;
    }

    public void setNullValueDisplay(String nullValueDisplay) {
        this.nullValueDisplay = nullValueDisplay;
    }

    public void textChanged() {
        String newValue = this.getText();
        BeanService.setPropertyValue(this.lastValue, this.propertyName, newValue);
    }

    @Override
    public Component getListCellEditorComponent(JList list, Object value, int index) {
        Object propertyValue = BeanService.getPropertyValue(value, this.propertyName);
        if (propertyValue == null) {
            propertyValue = this.nullValueDisplay;
        }
        this.setText(propertyValue.toString());
        this.lastValue = value;
        return this;
    }
}

