/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class JMListModel<T extends Comparable<? super T>>
extends AbstractListModel<T> {
    private Vector<T> model = new Vector();
    private boolean ordered;
    private Comparator<T> orderer;

    public JMListModel() {
    }

    public JMListModel(T[] elements) {
        this(Arrays.asList(elements));
    }

    public JMListModel(Collection<T> elements) {
        this();
        this.addAll(elements);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public Comparator<T> getOrderer() {
        return this.orderer;
    }

    public void setOrderer(Comparator<T> orderer) {
        if (orderer == null) {
            return;
        }
        this.ordered = true;
        this.orderer = orderer;
    }

    @Override
    public T getElementAt(int index) {
        if (index < 0 || index >= this.model.size()) {
            return null;
        }
        return (T)((Comparable)this.model.get(index));
    }

    public boolean contains(T element) {
        return this.model.contains(element);
    }

    @Override
    public int getSize() {
        return this.model.size();
    }

    public void addElement(T element) {
        this.model.add(element);
        if (this.ordered) {
            this.order();
        }
        this.fireIntervalAdded(this, this.model.size(), this.model.size());
    }

    public void addAll(T[] elements) {
        this.addAll(Arrays.asList(elements));
    }

    public void addAll(Collection<T> elements) {
        int sizeBefore = this.model.size();
        this.model.addAll(elements);
        if (this.ordered) {
            this.order();
        }
        this.fireIntervalAdded(this, sizeBefore, this.model.size());
    }

    public T getLastElement() {
        if (this.model == null || this.model.size() == 0) {
            return null;
        }
        return this.get(this.model.size() - 1);
    }

    public T get(int index) throws IndexOutOfBoundsException {
        return (T)((Comparable)this.model.get(index));
    }

    public Collection<T> getAll() {
        ArrayList<T> modelClone = new ArrayList<T>(this.model);
        return modelClone;
    }

    public void getAll(Collection<T> collection) {
        if (collection == null) {
            return;
        }
        collection.addAll(this.getAll());
    }

    public void insertElement(T element, int location) {
        this.model.add(location, element);
        this.fireIntervalAdded(this, location, location);
    }

    public void insertAll(T[] elements, int location) {
        this.insertAll(Arrays.asList(elements), location);
    }

    public void insertAll(Collection<T> elements, int location) {
        int startLocation = location;
        for (Comparable element : elements) {
            this.model.add(location++, element);
        }
        this.order();
        this.fireIntervalAdded(this, startLocation, location);
    }

    public void removeElement(int index) {
        if (index < 0 || index >= this.model.size()) {
            return;
        }
        this.model.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElement(T element) {
        int index = this.model.indexOf(element);
        if (index == -1) {
            return;
        }
        this.model.remove(element);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeAll(T[] elements) {
        this.removeAll(Arrays.asList(elements));
    }

    public void removeAll(Collection<T> elements) {
        for (Comparable element : elements) {
            int index = this.model.indexOf(element);
            if (index == -1) continue;
            this.model.remove(element);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void removeDuplicates() {
        int size = this.getSize();
        int i = 0;
        while (i < size - 1) {
            T source = this.get(i);
            int j = size - 1;
            while (j > i) {
                T target = this.get(j);
                if (target.equals(source)) {
                    this.removeElement(j);
                    --size;
                }
                --j;
            }
            ++i;
        }
    }

    public void setAll(Collection<T> elements) {
        this.clear();
        this.addAll(elements);
    }

    public void swap(int firstElement, int secondElement) throws IndexOutOfBoundsException {
        if (this.model == null || this.model.size() == 0) {
            return;
        }
        int modelSize = this.model.size();
        if (firstElement < 0 || firstElement >= modelSize) {
            throw new IndexOutOfBoundsException("JMListModel.swap(int, int):  First element index of " + firstElement + " is out of bounds.  List model size is " + modelSize);
        }
        if (secondElement < 0 || secondElement >= modelSize) {
            throw new IndexOutOfBoundsException("JMListModel.swap(int, int):  Second element index of " + secondElement + " is out of bounds.  List model size is " + modelSize);
        }
        Collections.swap(this.model, firstElement, secondElement);
    }

    public void swap(T firstElement, T secondElement) throws NoSuchElementException {
        if (this.model == null || this.model.size() == 0) {
            return;
        }
        int firstIndex = this.model.indexOf(firstElement);
        if (firstIndex == -1) {
            throw new NoSuchElementException("JMListModel.swap(Object, Object):  There First element does not exist within this model");
        }
        int secondIndex = this.model.indexOf(secondElement);
        if (secondIndex == -1) {
            throw new NoSuchElementException("JMListModel.swap(Object, Object):  There Second element does not exist within this model");
        }
        this.swap(firstIndex, secondIndex);
    }

    public void order() {
        if (this.ordered) {
            if (this.orderer != null) {
                Collections.sort(this.model, this.orderer);
            } else {
                Collections.sort(this.model);
            }
            this.fireContentsChanged(this, 0, this.model.size());
        }
    }

    public void reverse() {
        if (this.ordered) {
            Collections.reverse(this.model);
        }
    }

    public void clear() {
        int size = this.model.size();
        this.model.clear();
        this.fireIntervalRemoved(this, 0, size);
    }
}

