/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.swing.list.SelectionChangedListener;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JMListSelectionListener
implements ListSelectionListener {
    private SelectionChangedListener target;
    private JList list;
    private int valueChangedInstance = 0;

    public JMListSelectionListener() {
    }

    public JMListSelectionListener(JList list) {
        this();
        this.setList(list);
    }

    public JMListSelectionListener(JList list, SelectionChangedListener target) {
        this(list);
        this.setTarget(target);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.target == null) {
            throw new IllegalStateException("JMListSelectionListener.valueChanged:  The SelectionListener target has not been set.");
        }
        ++this.valueChangedInstance;
        if (this.valueChangedInstance == 3) {
            this.valueChangedInstance = 0;
            if (this.list.getSelectionMode() == 0) {
                int index = e.getLastIndex();
                this.target.selectionChanged(index, this.list.getModel().getElementAt(index));
            } else {
                this.target.selectionChanged(this.list.getSelectedIndices(), this.list.getSelectedValues());
            }
        }
    }

    public SelectionChangedListener getTarget() {
        return this.target;
    }

    public void setTarget(SelectionChangedListener target) {
        this.target = target;
    }

    public JList getList() {
        return this.list;
    }

    public void setList(JList list) {
        if (this.list != null) {
            this.list.removeListSelectionListener(this);
        }
        this.list = list;
        this.list.addListSelectionListener(this);
    }
}

