/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SynchronizedListModel<T>
implements ListModel {
    private ArrayList<T> dataModel;
    private ArrayList<ListDataListener> listDataListeners = new ArrayList();

    public SynchronizedListModel(ArrayList<T> dataModel) {
        this.setDataModel(dataModel);
    }

    public void add(T element) {
        if (element == null) {
            return;
        }
        this.dataModel.add(element);
        int size = this.dataModel.size();
        this.notifyListDataListeners(1, size, size);
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        if (listener == null) {
            return;
        }
        this.listDataListeners.add(listener);
    }

    public void clear() {
        int size = this.dataModel.size();
        this.dataModel.clear();
        this.notifyListDataListeners(2, 0, size);
    }

    public boolean contains(T element) {
        return this.dataModel.contains(element);
    }

    public Object get(int index) {
        return this.dataModel.get(index);
    }

    public Iterator<T> getAll() {
        return this.dataModel.iterator();
    }

    public ArrayList<T> getDataModel() {
        return this.dataModel;
    }

    public Object getElementAt(int index) {
        return this.dataModel.get(index);
    }

    @Override
    public int getSize() {
        return this.dataModel.size();
    }

    public int indexOf(T element) {
        return this.dataModel.indexOf(element);
    }

    public void insert(T element, int index) {
        this.dataModel.add(index, element);
        this.notifyListDataListeners(1, index, index);
    }

    public boolean isEmpty() {
        return this.dataModel.size() == 0;
    }

    public int lastIndexOf(T element) {
        return this.dataModel.lastIndexOf(element);
    }

    private void notifyListDataListeners(int type, int fromIndex, int toIndex) {
        if (this.listDataListeners.size() == 0) {
            return;
        }
        ListDataEvent event = new ListDataEvent(this, type, fromIndex, toIndex);
        for (ListDataListener listener : this.listDataListeners) {
            listener.contentsChanged(event);
        }
    }

    public void remove(T element) {
        this.remove(this.dataModel.indexOf(element));
    }

    public void remove(int index) {
        if (index < 0 || index >= this.dataModel.size()) {
            return;
        }
        this.dataModel.remove(index);
        this.notifyListDataListeners(2, index, index);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listDataListeners.remove(listener);
    }

    public void set(int index, T element) {
        this.dataModel.set(index, element);
        this.notifyListDataListeners(0, index, index);
    }

    public void setDataModel(ArrayList<T> dataModel) throws IllegalArgumentException {
        if (dataModel == null) {
            throw new IllegalArgumentException("SynchronizedListModel can only work with a valid data model.  Make sure the data model you send is not null.");
        }
        if (this.dataModel != null) {
            this.notifyListDataListeners(2, 0, this.dataModel.size());
        }
        this.dataModel = dataModel;
        this.notifyListDataListeners(1, 0, this.dataModel.size());
    }

    public T[] toArray() {
        return this.dataModel.toArray();
    }
}

