/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMImageIcon;
import com.jmorgan.swing.menu.MenuItemProperties;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public final class MenuConstants {
    private static String artRoot;
    public static final Font menuFont;
    public static final MenuItemProperties fileNewProperties;
    public static final MenuItemProperties fileOpenProperties;
    public static final MenuItemProperties fileCloseProperties;
    public static final MenuItemProperties fileSaveProperties;
    public static final MenuItemProperties fileSaveAsProperties;
    public static final MenuItemProperties fileExportProperties;
    public static final MenuItemProperties filePrintProperties;
    public static final MenuItemProperties filePrinterSetupProperties;
    public static final MenuItemProperties fileExitProperties;
    public static final MenuItemProperties editUndoProperties;
    public static final MenuItemProperties editRedoProperties;
    public static final MenuItemProperties editAddProperties;
    public static final MenuItemProperties editInsertProperties;
    public static final MenuItemProperties editDeleteProperties;
    public static final MenuItemProperties editCutProperties;
    public static final MenuItemProperties editCopyProperties;
    public static final MenuItemProperties editPasteProperties;
    public static final MenuItemProperties searchFindProperties;
    public static final MenuItemProperties searchReplaceProperties;
    public static final MenuItemProperties helpTopicsProperties;
    public static final MenuItemProperties helpAboutProperties;

    static {
        GUIApplication appManager = GUIApplication.getGUIApplication();
        artRoot = appManager == null ? "/resources/" : String.format("/%s", appManager.getArtRoot());
        menuFont = UIManager.getFont("Menu.font");
        fileNewProperties = new MenuItemProperties("&New", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "FileNew.png"), "Create a new document"), 10, KeyStroke.getKeyStroke(78, 128));
        fileOpenProperties = new MenuItemProperties("&Open", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "FileOpen.png"), "Open an existing document"), 20, KeyStroke.getKeyStroke(79, 128));
        fileCloseProperties = new MenuItemProperties("&Close", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Close.png"), "Close the current document"), 30, KeyStroke.getKeyStroke(87, 128));
        fileSaveProperties = new MenuItemProperties("&Save", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Save.png"), "Save the current document"), 40, KeyStroke.getKeyStroke(83, 128));
        fileSaveAsProperties = new MenuItemProperties("Save &As...", (ImageIcon)new JMImageIcon(GUIApplication.getMenuResource(artRoot, "SaveAs.png"), "Save the current document under a specified name"), 50);
        fileExportProperties = new MenuItemProperties("&Export...", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Export.png"), "Export the current document"), 60, KeyStroke.getKeyStroke(69, 128));
        filePrintProperties = new MenuItemProperties("&Print", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Printer.png"), "Print the current document"), 60000, KeyStroke.getKeyStroke(80, 128));
        filePrinterSetupProperties = new MenuItemProperties("Pr&int Setup", (ImageIcon)new JMImageIcon(GUIApplication.getMenuResource(artRoot, "PrinterSetup.png"), "Setup the Printer"), 61000);
        fileExitProperties = new MenuItemProperties("E&xit", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Exit.png"), "Exit the Application"), 100000, KeyStroke.getKeyStroke(115, 128));
        editUndoProperties = new MenuItemProperties("&Undo", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Undo.png"), "Undo the last operation"), 80, KeyStroke.getKeyStroke(90, 128));
        editRedoProperties = new MenuItemProperties("&Redo", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Redo.png"), "Redo the last undo"), 90, KeyStroke.getKeyStroke(90, 192));
        editAddProperties = new MenuItemProperties("&Add", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Add.png"), "Add"), 100, KeyStroke.getKeyStroke(65, 128));
        editInsertProperties = new MenuItemProperties("&Insert", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Insert.png"), "Insert"), 110, KeyStroke.getKeyStroke(155, 128));
        editDeleteProperties = new MenuItemProperties("&Delete", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Delete.png"), "Delete"), 120, KeyStroke.getKeyStroke(127, 128));
        editCutProperties = new MenuItemProperties("Cu&t", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Cut.png"), "Cut"), 130, KeyStroke.getKeyStroke(88, 128));
        editCopyProperties = new MenuItemProperties("&Copy", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Copy.png"), "Copy"), 140, KeyStroke.getKeyStroke(67, 128));
        editPasteProperties = new MenuItemProperties("&Paste", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Paste.png"), "Paste"), 150, KeyStroke.getKeyStroke(86, 128));
        searchFindProperties = new MenuItemProperties("&Find", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Search.png"), "Search for content within the current document"), 160, KeyStroke.getKeyStroke(70, 128));
        searchReplaceProperties = new MenuItemProperties("&Replace", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "Replace.png"), "Replace content with replacement text"), 170, KeyStroke.getKeyStroke(82, 128));
        helpTopicsProperties = new MenuItemProperties("&Topics", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "HelpTopics.png"), "Help Topics"), 90000, KeyStroke.getKeyStroke(112, 0));
        helpAboutProperties = new MenuItemProperties("&About...", new JMImageIcon(GUIApplication.getMenuResource(artRoot, "About.png"), "Help Topics"), 99000, KeyStroke.getKeyStroke(112, 128));
    }

    private MenuConstants() {
    }
}

