/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.swing.menu.MenuService;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MenuListenerService
extends MenuService {
    private static final int ACTION_ADD = 0;
    private static final int ACTION_REMOVE = 1;

    public MenuListenerService(JMenu client) {
        super(client);
    }

    public void addActionListener(ActionListener al) {
        this.handleActionListener(al, 0);
    }

    public void addActionListener(String menuID, int type, ActionListener al) {
        this.handleActionListener(menuID, type, al, 0);
    }

    public void removeActionListener(ActionListener al) {
        this.handleActionListener(al, 1);
    }

    public void removeActionListener(String menuID, int type, ActionListener al) {
        this.handleActionListener(menuID, type, al, 1);
    }

    private void handleActionListener(ActionListener al, int action) {
        Component[] miList = this.client.getMenuComponents();
        int i = 0;
        while (i < miList.length) {
            if (miList[i] instanceof JMenu) {
                MenuListenerService mls = new MenuListenerService((JMenu)miList[i]);
                mls.handleActionListener(al, action);
            } else if (miList[i] instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)miList[i];
                switch (action) {
                    case 0: {
                        menuItem.addActionListener(al);
                        break;
                    }
                    case 1: {
                        menuItem.removeActionListener(al);
                    }
                }
            }
            ++i;
        }
    }

    private void handleActionListener(String menuID, int type, ActionListener al, int action) {
        Component[] miList = this.client.getComponents();
        AbstractButton item = null;
        int i = 0;
        while (i < miList.length) {
            if (miList[i] instanceof JMenu) {
                JMenu menu = (JMenu)miList[i];
                String compareID = "";
                switch (type) {
                    case 0: {
                        compareID = menu.getText();
                        break;
                    }
                    case 1: {
                        compareID = menu.getActionCommand();
                    }
                }
                if (compareID.equalsIgnoreCase(menuID)) {
                    MenuListenerService mls = new MenuListenerService(menu);
                    switch (action) {
                        case 0: {
                            mls.addActionListener(al);
                            break;
                        }
                        case 1: {
                            mls.removeActionListener(al);
                        }
                    }
                    return;
                }
                item = this.findItem(menuID, type);
                if (item != null) break;
            }
            ++i;
        }
        switch (action) {
            case 0: {
                item.addActionListener(al);
                break;
            }
            case 1: {
                item.removeActionListener(al);
            }
        }
    }
}

