/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.event.ChangeEventInvoker;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.MenuBarService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.SingleSelectionModel;

public class MenuStateService
extends MenuBarService
implements AWTEventListener {
    private Collection<Component> components;
    private Collection<JMenuItem> menuItems;
    private SingleSelectionModel selectionModel;
    private boolean busy = false;
    private boolean needToRefresh;
    private AsynchMethodInvoker<Void> refreshJob;

    public MenuStateService(JMenuBar client) {
        super(client);
        this.selectionModel = client.getSelectionModel();
        new ChangeEventInvoker(this.selectionModel, this, "scheduleRefresh", 0);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 3L);
        new AsynchMethodInvoker((Object)this, "refresh", 500);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Component source = (Component)event.getSource();
        String componentName = source.getName();
        if (componentName == null) {
            componentName = source.getClass().getName();
        }
        if (componentName.endsWith("CellRendererPane") || componentName.endsWith("JMScrollPane$ScrollBar") || componentName.endsWith("null.layeredPane")) {
            return;
        }
        switch (event.getID()) {
            case 300: 
            case 301: {
                if (this.components != null && this.components.contains(source)) {
                    if (this.busy) {
                        this.needToRefresh = true;
                    }
                    int waitCount = 0;
                    while (this.busy && waitCount < 20) {
                        ThreadUtility.sleep(100L);
                        ++waitCount;
                    }
                    this.busy = false;
                    this.needToRefresh = false;
                    this.components.clear();
                    this.components = null;
                    this.scheduleRefresh();
                    break;
                }
                return;
            }
            case 101: 
            case 102: 
            case 103: {
                if (this.components == null || !this.components.contains(source)) break;
                this.scheduleRefresh();
            }
        }
    }

    private void scheduleRefresh() {
        this.scheduleRefresh(250);
    }

    private void scheduleRefresh(int delay) {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
        this.refreshJob = new AsynchMethodInvoker((Object)this, "refresh", delay);
    }

    public void refresh() {
        if (this.busy) {
            return;
        }
        this.busy = true;
        if (this.components == null) {
            this.components = GUIServices.getAllComponents(this.getTopMenuContainer());
            if (this.components == null) {
                this.busy = false;
                return;
            }
        }
        ArrayList<Component> visibleComponents = new ArrayList<Component>();
        for (Component component : this.components) {
            if (!component.isVisible() || !component.isShowing() || component instanceof JMenuItem || component instanceof JToolBar) continue;
            visibleComponents.add(component);
        }
        if (this.menuItems == null) {
            this.menuItems = this.getMenuItems();
        }
        for (MenuElement menuElement : this.menuItems) {
            if (this.needToRefresh) break;
            if (!(menuElement instanceof JMMenuItem)) continue;
            JMMenuItem menuItem = (JMMenuItem)menuElement;
            boolean functionFound = false;
            boolean permitted = true;
            String functionName = menuItem.getMenuFunction();
            String permitFunctionName = functionName + "Enabled";
            if (this.components == null) {
                System.err.println("MenuStateService.refresh():  components is null... how????");
                this.busy = false;
                return;
            }
            String componentName = "";
            for (Component comp : visibleComponents) {
                if (this.needToRefresh) break;
                componentName = comp.getName();
                if (StringUtility.isEmpty(componentName)) {
                    componentName = comp.getClass().getName();
                }
                try {
                    new MethodInvoker((Object)comp, functionName, new Object[0]);
                    functionFound = true;
                    if (!functionFound) break;
                    try {
                        permitted = (Boolean)new MethodInvoker((Object)comp, permitFunctionName, new Object[0]).invoke();
                    }
                    catch (Exception exception) {}
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setEnabled(functionFound && permitted);
        }
        this.busy = false;
        this.needToRefresh = false;
    }
}

