/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.spinner;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.awt.SpinnerShapeCreator;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.decorator.ArrowDecorator;
import com.jmorgan.swing.event.MouseEventInvoker;
import com.jmorgan.swing.spinner.SpinEvent;
import com.jmorgan.swing.spinner.SpinListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.UIManager;

public class Spinner
extends JMPanel
implements KeyListener {
    private static final int MAX_SPIN_SPEED = 50;
    private static final int MIN_SPIN_SPEED = 250;
    private static final int SPIN_SPEED_INC = 25;
    private static final int SPIN_START_WAIT = 125;
    protected JMButton spinUp;
    protected JMButton spinDown;
    private Color arrowColor;
    private Color disabledArrowColor;
    private boolean fastSpinUp;
    private boolean fastSpinDown;
    private int spinSpeed;
    protected Component component;
    protected ArrayList<SpinListener> spinListeners;
    protected Object oldValue;
    protected Object newValue;

    public Spinner(Component c) {
        String spinDownToolTip;
        this.setOpaque(false);
        this.setShapeCreator(null);
        this.setLayout(new BorderLayout());
        this.spinListeners = new ArrayList();
        String spinUpToolTip = UIManager.getString("Spinner.spinUpToolTip");
        if (spinUpToolTip == null) {
            UIManager.put("Spinner.spinUpToolTip", "Spin Up");
        }
        if ((spinDownToolTip = UIManager.getString("Spinner.spinDownToolTip")) == null) {
            UIManager.put("Spinner.spinDownToolTip", "Spin Down");
        }
        this.spinUp = this.createButton(1, "Up");
        this.spinDown = this.createButton(5, "Down");
        JMPanel sp = new JMPanel(new GridLayout(2, 1));
        sp.setOpaque(false);
        sp.setShapeCreator(null);
        sp.add(this.spinUp);
        sp.add(this.spinDown);
        this.add((Component)sp, "East");
        this.setComponent(c);
        SpinnerShapeCreator shapeCreator = (SpinnerShapeCreator)UIManager.get("Spinner.shapeCreator");
        if (shapeCreator != null) {
            if (c instanceof JMTextField) {
                JMTextField tf = (JMTextField)c;
                tf.setShapeCreator(shapeCreator.getComponentShapeCreator());
            }
            this.spinUp.setShapeCreator(shapeCreator.getSpinUpButtonShapeCreator());
            this.spinDown.setShapeCreator(shapeCreator.getSpinDownButtonShapeCreator());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.component.setEnabled(enabled);
        this.spinDown.setEnabled(enabled);
        ArrowDecorator decorator = (ArrowDecorator)this.spinDown.getDecorator();
        decorator.setArrowColor(enabled ? this.arrowColor : this.disabledArrowColor);
        this.spinUp.setEnabled(enabled);
        decorator = (ArrowDecorator)this.spinUp.getDecorator();
        decorator.setArrowColor(enabled ? this.arrowColor : this.disabledArrowColor);
    }

    @Reflected
    public void startFastSpinUp() {
        if (this.fastSpinUp) {
            return;
        }
        this.fastSpinDown = false;
        this.fastSpinUp = true;
        this.startFastSpin("fastSpinUp", this.spinUp);
    }

    public void stopFastSpinUp() {
        this.fastSpinUp = false;
        this.fastSpinDown = false;
    }

    @Reflected
    public void fastSpinUp() {
        this.fastSpin(this.fastSpinUp, this.spinUp, "spinUp", "fastSpinUp");
    }

    @Reflected
    public void startFastSpinDown() {
        if (this.fastSpinDown) {
            return;
        }
        this.fastSpinUp = false;
        this.fastSpinDown = true;
        this.startFastSpin("fastSpinDown", this.spinDown);
    }

    private void startFastSpin(String method, JMButton spinButton) {
        this.spinSpeed = 250;
        this.spin(spinButton);
        new AsynchMethodInvoker((Object)this, method, 125);
    }

    public void stopFastSpinDown() {
        this.fastSpinDown = false;
        this.fastSpinUp = false;
    }

    @Reflected
    public void fastSpinDown() {
        this.fastSpin(this.fastSpinDown, this.spinDown, "spinDown", "fastSpinDown");
    }

    private void fastSpin(boolean threadState, JMButton source, String command, String method) {
        if (threadState) {
            this.spin(source);
            new AsynchMethodInvoker((Object)this, method, this.spinSpeed);
            if (this.spinSpeed > 50) {
                this.spinSpeed -= 25;
            }
        }
    }

    private void spin(JMButton spinButton) {
        SpinEvent se = null;
        this.component.requestFocus();
        for (SpinListener sl : this.spinListeners) {
            if (se == null) {
                se = new SpinEvent(this.component, spinButton == this.spinUp ? 0 : 1);
            }
            if (spinButton == this.spinUp) {
                sl.spinUp(se);
            }
            if (spinButton != this.spinDown) continue;
            sl.spinDown(se);
        }
    }

    private JMButton createButton(int direction, String methodExt) {
        this.arrowColor = UIManager.getColor("Spinner.arrowColor");
        if (this.arrowColor == null) {
            this.arrowColor = Color.black;
        }
        this.disabledArrowColor = UIManager.getColor("Spinner.disabledArrowColor");
        if (this.disabledArrowColor == null) {
            this.disabledArrowColor = Color.LIGHT_GRAY;
        }
        ArrowDecorator decorator = new ArrowDecorator(direction, this.arrowColor);
        JMButton button = new JMButton(decorator);
        button.getAccessibleContext().setAccessibleDescription("Click this button or press the " + (direction == 1 ? "up arrow" : "down arrow") + " to " + (direction == 1 ? "increment" : "decrement") + " the current value.");
        MouseEventInvoker startFSMI = new MouseEventInvoker((Object)button, 8, this, "startFastSpin" + methodExt);
        startFSMI.setInvokeSynchronously(true);
        MouseEventInvoker stopFSMI = new MouseEventInvoker((Object)button, 16, this, "stopFastSpin" + methodExt);
        stopFSMI.setInvokeSynchronously(true);
        button.setFocusable(false);
        button.setText("");
        button.setToolTipText(direction == 1 ? UIManager.getString("Spinner.spinUpToolTip") : UIManager.getString("Spinner.spinDownToolTip"));
        button.setBorder(UIManager.getBorder("Spinner.arrowButtonBorder"));
        button.setInsets(UIManager.getInsets("Spinner.arrowButtonInsets"));
        button.setForeground(UIManager.getColor("Spinner.foreground"));
        button.setBackground(UIManager.getColor("Spinner.background"));
        button.setPreferredSize(new Dimension(14, 14));
        return button;
    }

    public JMButton getSpinUpButton() {
        return this.spinUp;
    }

    public JMButton getSpinDownButton() {
        return this.spinDown;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component c) {
        if (this.component != null) {
            this.component.removeKeyListener(this);
            this.remove(this.component);
        }
        this.component = c;
        this.add(this.component, "Center");
        Dimension d = this.component.getPreferredSize();
        d.width += 16;
        d.height = 23;
        this.setPreferredSize(d);
        c.addKeyListener(this);
    }

    public void addSpinListener(SpinListener listener) {
        this.spinListeners.add(listener);
    }

    public void removeSpinListener(SpinListener listener) {
        this.spinListeners.remove(listener);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 38: {
                this.spin(this.spinUp);
                break;
            }
            case 40: {
                this.spin(this.spinDown);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

