/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.spinner;

import com.jmorgan.swing.TimeField;
import com.jmorgan.swing.spinner.SpinEvent;
import com.jmorgan.swing.spinner.SpinListener;
import com.jmorgan.swing.spinner.Spinner;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringIndexer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;

public class TimeSpinner
extends Spinner
implements SpinListener,
PropertyChangeListener {
    private int[] hourFields;
    private int[] minuteFields;
    private int[] secondFields;

    public TimeSpinner(TimeField tf) {
        super(tf);
        this.indexTimeFields(tf.getFormatString());
        tf.addPropertyChangeListener(this);
        this.addSpinListener(this);
    }

    @Override
    public void spinUp(SpinEvent e) {
        this.spin(e);
    }

    @Override
    public void spinDown(SpinEvent e) {
        this.spin(e);
    }

    private void spin(SpinEvent e) {
        TimeField tf = (TimeField)e.getSource();
        if (tf.isNull()) {
            return;
        }
        Calendar thisTime = tf.getTime();
        if (thisTime == null) {
            return;
        }
        this.oldValue = thisTime;
        int caretPos = tf.getCaretPosition();
        int spinDir = e.getSpinDirection() == 1 ? -1 : 1;
        boolean inSpinRange = false;
        int direction = caretPos == 0 ? 1 : -1;
        int location = caretPos;
        while (!inSpinRange) {
            if (Comparison.isIn(location, this.secondFields)) {
                thisTime.add(13, spinDir);
                inSpinRange = true;
            } else if (Comparison.isIn(location, this.minuteFields)) {
                thisTime.add(12, spinDir);
                inSpinRange = true;
            } else if (Comparison.isIn(location, this.hourFields)) {
                thisTime.add(10, spinDir);
                inSpinRange = true;
            }
            if (inSpinRange) continue;
            location += direction;
        }
        this.newValue = thisTime;
        tf.setTime(thisTime);
        tf.requestFocus();
        tf.setCaretPosition(caretPos);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("formatString")) {
            this.indexTimeFields((String)evt.getNewValue());
        }
    }

    private void indexTimeFields(String formatString) {
        if (formatString == null) {
            return;
        }
        this.hourFields = StringIndexer.indexCharacter(formatString, 'H');
        this.minuteFields = StringIndexer.indexCharacter(formatString, 'm');
        this.secondFields = StringIndexer.indexCharacter(formatString, 's');
    }
}

