/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.style;

import com.jmorgan.swing.style.BorderStyle;
import com.jmorgan.swing.style.ColorStyle;
import com.jmorgan.swing.style.ComponentStyle;
import java.awt.Font;
import javax.swing.UIManager;

public class TextStyle
extends ComponentStyle {
    public static final String FONT = "font";

    public static final TextStyle getDefaultTextStyle(String uiType) {
        Font font = UIManager.getFont(uiType + ".font");
        if (font == null) {
            return null;
        }
        BorderStyle borderStyle = BorderStyle.getDefaultBorderStyle(uiType);
        if (borderStyle == null) {
            return null;
        }
        ColorStyle colorStyle = ColorStyle.getDefaultColorStyle(uiType);
        if (colorStyle == null) {
            return null;
        }
        TextStyle style = new TextStyle(colorStyle, borderStyle, font);
        return style;
    }

    public TextStyle() {
    }

    public TextStyle(ColorStyle colorStyle, BorderStyle border, Font font) {
        super(colorStyle, border);
        this.setFont(font);
    }

    public Font getFont() {
        return (Font)this.getStyle(FONT);
    }

    public void setFont(Font font) {
        this.setStyle(FONT, font);
    }
}

