/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.tabbedpane;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class GhostGlassPane
extends JPanel {
    private final AlphaComposite alphaComposite;
    private Point location;
    private BufferedImage ghostImage;

    public GhostGlassPane() {
        this.setOpaque(false);
        this.location = new Point(0, 0);
        this.alphaComposite = AlphaComposite.getInstance(3, 0.7f);
    }

    public void setImage(BufferedImage draggingGhost) {
        this.ghostImage = draggingGhost;
    }

    public void setPoint(Point location) {
        this.location.x = location.x;
        this.location.y = location.y;
    }

    public int getGhostWidth() {
        if (this.ghostImage == null) {
            return 0;
        }
        return this.ghostImage.getWidth(this);
    }

    public int getGhostHeight() {
        if (this.ghostImage == null) {
            return 0;
        }
        return this.ghostImage.getHeight(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.ghostImage == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(this.alphaComposite);
        g2.drawImage((Image)this.ghostImage, (int)this.location.getX(), (int)this.location.getY(), null);
    }
}

