/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.tabbedpane;

import com.jmorgan.beans.JMBean;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.tabbedpane.TabPlacementDNDController;
import com.jmorgan.swing.tabbedpane.TabTransferable;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;

public class JMDragGestureListener
extends JMBean
implements DragGestureListener {
    private TabPlacementDNDController dndController;
    private DragSourceListener dragSourceListener;

    public JMDragGestureListener(TabPlacementDNDController dndController, DragSourceListener dragSourceListener) {
        this.dndController = dndController;
        this.dragSourceListener = dragSourceListener;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent gestureEvent) {
        Point tabPt = gestureEvent.getDragOrigin();
        JMTabbedPane tabbedPane = this.dndController.getTabbedPane();
        int dragTabIndex = tabbedPane.indexAtLocation(tabPt.x, tabPt.y);
        if (dragTabIndex < 0) {
            return;
        }
        this.dndController.initGlassPane(gestureEvent.getComponent(), gestureEvent.getDragOrigin(), dragTabIndex);
        try {
            TabTransferable tabTransferable = new TabTransferable(tabbedPane, dragTabIndex);
            gestureEvent.startDrag(DragSource.DefaultMoveDrop, tabTransferable, this.dragSourceListener);
        }
        catch (InvalidDnDOperationException idoe) {
            idoe.printStackTrace();
        }
    }
}

