/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.tabbedpane;

import com.jmorgan.beans.JMBean;
import com.jmorgan.swing.tabbedpane.TabPlacementDNDController;
import com.jmorgan.swing.tabbedpane.TabTransferData;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;

public class JMDragSourceListener
extends JMBean
implements DragSourceListener {
    private TabPlacementDNDController dndController;

    public JMDragSourceListener(TabPlacementDNDController dndController) {
        this.dndController = dndController;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragOver(DragSourceDragEvent dragEvent) {
        TabTransferData data = this.dndController.getTabTransferData(dragEvent);
        if (data == null) {
            dragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        } else {
            dragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        System.out.println("JMDragSourceListener.dropActionChanged(): Need to modify or delete");
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        this.dndController.stopDragging();
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dndController.resetRect();
        if (this.dndController.hasGhost()) {
            this.dndController.hideGlassPane();
        }
    }
}

