/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.tabbedpane;

import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.tabbedpane.TabAcceptor;
import com.jmorgan.swing.tabbedpane.TabPlacementDNDController;
import com.jmorgan.swing.tabbedpane.TabTransferData;
import com.jmorgan.swing.tabbedpane.TabbedPaneDNDConstants;
import com.jmorgan.swing.util.GUIServices;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

class JMDropTargetListener
extends JMBean
implements DropTargetListener {
    private TabPlacementDNDController dndController;
    private JMTabbedPane tabbedPane;

    public JMDropTargetListener(TabPlacementDNDController dndController) {
        this.dndController = dndController;
        this.tabbedPane = this.dndController.getTabbedPane();
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (this.isDragAcceptable(e)) {
            e.acceptDrag(e.getDropAction());
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.dndController.setShouldDrawRect(false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.dndController.updateGlassPane(e);
    }

    @Override
    public void drop(DropTargetDropEvent dropEvent) {
        if (this.isDropAcceptable(dropEvent)) {
            this.dndController.convertTab(this.dndController.getTabTransferData(dropEvent), this.dndController.getTargetTabIndex(dropEvent.getLocation()));
            dropEvent.dropComplete(true);
        } else {
            dropEvent.dropComplete(false);
        }
        this.dndController.setShouldDrawRect(false);
        this.tabbedPane.repaint();
    }

    public boolean isDragAcceptable(DropTargetDragEvent dragEvent) {
        return this.isActionAcceptable(dragEvent);
    }

    public boolean isDropAcceptable(DropTargetDropEvent dropEvent) {
        return this.isActionAcceptable(dropEvent);
    }

    private boolean isActionAcceptable(DropTargetEvent dropTargetEvent) {
        TabAcceptor acceptor;
        Transferable transferrable = (Transferable)new MethodInvoker((Object)dropTargetEvent, "getTransferable", new Object[0]).invoke();
        if (transferrable == null) {
            return false;
        }
        boolean transferDataFlavorFound = false;
        DataFlavor[] dataFlavorArray = transferrable.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor transferDataFlavor = dataFlavorArray[n2];
            if (TabbedPaneDNDConstants.TAB_TRANSFER_DATA_FLAVOR.equals(transferDataFlavor)) {
                transferDataFlavorFound = true;
                break;
            }
            ++n2;
        }
        if (!transferDataFlavorFound) {
            return false;
        }
        DataFlavor[] flavor = (DataFlavor[])new MethodInvoker((Object)dropTargetEvent, "getCurrentDataFlavors", new Object[0]).invoke();
        if (!transferrable.isDataFlavorSupported(flavor[0])) {
            return false;
        }
        TabTransferData data = null;
        data = dropTargetEvent instanceof DropTargetDragEvent ? this.dndController.getTabTransferData((DropTargetDragEvent)dropTargetEvent) : this.dndController.getTabTransferData((DropTargetDropEvent)dropTargetEvent);
        JMTabbedPane dataTabbedPane = data.getTabbedPane();
        int dataTabIndex = data.getTabIndex();
        if (this.tabbedPane == dataTabbedPane && dataTabIndex >= 0) {
            return true;
        }
        JMTabbedPane tabbedPaneParent = GUIServices.getParentByType(this.tabbedPane, JMTabbedPane.class);
        if (tabbedPaneParent != null && dataTabbedPane == tabbedPaneParent) {
            return false;
        }
        if (this.tabbedPane != dataTabbedPane && (acceptor = this.dndController.getAcceptor()) != null) {
            return acceptor.isDropAcceptable(dataTabbedPane, dataTabIndex);
        }
        return false;
    }
}

