/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMLabel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class DelegatedTableCellValueRenderer<ValueType, ResponseType>
extends JMLabel
implements TableCellRenderer {
    private Object renderer;
    private String renderingMethodName;

    public DelegatedTableCellValueRenderer(Object renderer, String renderingMethodName) {
        this.setOpaque(true);
        this.setRenderer(renderer);
        this.setRenderingMethodName(renderingMethodName);
    }

    public Object getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Object renderer) {
        this.renderer = renderer;
    }

    public String getRenderingMethodName() {
        return this.renderingMethodName;
    }

    public void setRenderingMethodName(String renderingMethodName) {
        this.renderingMethodName = renderingMethodName;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color evenBackground;
        Color background;
        Color foreground = isSelected ? table.getSelectionForeground() : table.getForeground();
        this.setForeground(foreground);
        Color color = background = isSelected ? table.getSelectionBackground() : table.getBackground();
        if (row % 2 == 0 && (evenBackground = UIManager.getColor("Table.alternateBackground")) != null) {
            background = evenBackground;
        }
        if (isSelected) {
            background = table.getSelectionBackground();
        }
        this.setBackground(background);
        this.setFont(table.getFont());
        if (value == null) {
            this.setText("");
            return this;
        }
        if (this.renderer != null) {
            MethodInvoker mi = new MethodInvoker(this.renderer, this.renderingMethodName, value, row, column);
            Object renderValue = mi.invoke();
            this.setText(String.valueOf(renderValue));
        } else {
            this.setText("");
        }
        return this;
    }
}

