/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.persistence.PersistenceService;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.ModifyingTableCellRenderer;
import com.jmorgan.swing.table.TableCellEditorRenderer;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DynamicBeanColumnModel
extends DefaultTableColumnModel
implements TableModelListener {
    private ArrayList<String> hiddenColumnNames;
    private ArrayList<TableColumn> hiddenColumns;
    private TableCellEditorRenderer editorRenderer;
    private DynamicBeanTableModel tableModel;
    private String[] preferredColumnOrder;
    private HashMap<String, String> columnTitles;
    private HashMap<String, TableCellRenderer> renderers;
    private HashMap<String, TableCellEditor> editors;

    static {
        PersistenceService.setTransient(DynamicBeanColumnModel.class, "listenerList");
    }

    public DynamicBeanColumnModel() {
        this.editorRenderer = new TableCellEditorRenderer();
    }

    public DynamicBeanColumnModel(DynamicBeanTableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public DynamicBeanColumnModel(DynamicBean bean) {
        this.init(bean);
    }

    public DynamicBeanColumnModel(String ... propertyNames) {
        this.init(propertyNames);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rowCount;
        int columnCount = this.getColumnCount();
        if (columnCount == 0 && (rowCount = this.tableModel.getRowCount()) > 0) {
            DynamicBean bean = this.tableModel.getValue(0);
            this.init(bean);
        }
    }

    public DynamicBeanTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DynamicBeanTableModel tableModel) {
        tableModel.addTableModelListener(this);
        this.tableModel = tableModel;
        int rowCount = this.tableModel.getRowCount();
        if (rowCount > 0) {
            DynamicBean bean = this.tableModel.getValue(0);
            this.init(bean);
            int c = 0;
            while (c < tableModel.getColumnCount()) {
                String columnName = tableModel.getColumnName(c);
                for (TableColumn tc : this.tableColumns) {
                    if (!tc.getIdentifier().equals(columnName)) continue;
                    tc.setModelIndex(c);
                    break;
                }
                ++c;
            }
        }
    }

    private void init(DynamicBean bean) {
        ArrayList<String> propertyNames = new ArrayList<String>(bean.getPropertyNames());
        Collections.sort(propertyNames);
        this.init(propertyNames.toArray(new String[propertyNames.size()]));
    }

    private void init(String ... propertyNames) {
        int index = 0;
        this.editorRenderer = new TableCellEditorRenderer();
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (!CollectionUtility.isNotEmpty(this.hiddenColumnNames) || !this.hiddenColumnNames.contains(propertyName)) {
                String columnTitle;
                String columnName = StringUtility.getDisplayableTitle(propertyName);
                int headerWidth = 75;
                index = this.tableModel != null ? this.tableModel.getColumnIndex(propertyName) : ++index;
                TableColumn tc = new TableColumn(index, headerWidth, this.editorRenderer, this.editorRenderer);
                tc.setHeaderValue(columnName);
                tc.setIdentifier(propertyName);
                if (!CollectionUtility.isEmpty(this.columnTitles) && (columnTitle = this.columnTitles.get(propertyName)) != null) {
                    tc.setHeaderValue(columnTitle);
                    this.columnTitles.remove(propertyName);
                }
                if (!CollectionUtility.isEmpty(this.renderers)) {
                    for (String regex : this.renderers.keySet()) {
                        if (!propertyName.matches(regex)) continue;
                        tc.setCellRenderer(this.renderers.get(regex));
                    }
                }
                if (!CollectionUtility.isEmpty(this.editors)) {
                    for (String regex : this.editors.keySet()) {
                        if (!propertyName.matches(regex)) continue;
                        tc.setCellEditor(this.editors.get(regex));
                    }
                }
                this.addColumn(tc);
            }
            ++n2;
        }
        if (this.preferredColumnOrder != null) {
            this.setColumnOrder(this.preferredColumnOrder);
        }
    }

    public String getColumnName(int columnNumber) {
        for (TableColumn tc : this.tableColumns) {
            if (tc.getModelIndex() != columnNumber) continue;
            String columnName = tc.getIdentifier().toString();
            return columnName;
        }
        return null;
    }

    public TableCellRenderer getRenderer(String columnName) {
        for (TableColumn tc : this.tableColumns) {
            if (!tc.getIdentifier().toString().equalsIgnoreCase(columnName)) continue;
            return tc.getCellRenderer();
        }
        return null;
    }

    public void setRenderer(int row, int column, TableCellRenderer renderer) {
        this.editorRenderer.setRenderer(row, column, renderer);
    }

    public void setRenderer(String columnNameRegex, TableCellRenderer renderer) {
        if (CollectionUtility.isEmpty(this.tableColumns)) {
            if (this.renderers == null) {
                this.renderers = new HashMap();
            }
            this.renderers.put(columnNameRegex, renderer);
            return;
        }
        for (TableColumn tc : this.tableColumns) {
            if (!Pattern.matches(columnNameRegex, tc.getIdentifier().toString())) continue;
            tc.setCellRenderer(renderer);
        }
    }

    public void setRenderer(Class<?> type, TableCellRenderer renderer) {
        this.editorRenderer.setRenderer(type, renderer);
    }

    public void addModifyingRenderer(ModifyingTableCellRenderer renderer) {
        this.editorRenderer.addModifyingRenderer(renderer);
    }

    public TableCellEditor getEditor(String columnName) {
        for (TableColumn tc : this.tableColumns) {
            if (!tc.getIdentifier().toString().equalsIgnoreCase(columnName)) continue;
            return tc.getCellEditor();
        }
        return null;
    }

    public void setEditor(int row, int column, TableCellEditor editor) {
        this.editorRenderer.setEditor(row, column, editor);
    }

    public void setEditor(String columnNameRegex, TableCellEditor editor) {
        if (CollectionUtility.isEmpty(this.tableColumns)) {
            if (this.editors == null) {
                this.editors = new HashMap();
            }
            this.editors.put(columnNameRegex, editor);
            return;
        }
        for (TableColumn tc : this.tableColumns) {
            if (!Pattern.matches(columnNameRegex, tc.getIdentifier().toString())) continue;
            tc.setCellEditor(editor);
        }
    }

    public void addComputedColumn(String columnName, Class<?> columnType) {
        TableColumn tc = new TableColumn(this.tableColumns.size(), 75);
        tc.setHeaderValue(StringUtility.getDisplayableTitle(columnName));
        tc.setIdentifier(columnName);
        this.addColumn(tc);
    }

    public void setColumnWidth(String columnName, int width) {
        try {
            this.setColumnWidth(this.getColumnIndex(columnName), width);
        }
        catch (IllegalArgumentException e) {
            System.err.printf("DynamicBeanColumnModel.setColumnWidth(columnName=%s, width=%d):  %s\n", columnName, width, e.getMessage());
            e.printStackTrace();
        }
    }

    public void setColumnWidth(int index, int width) {
        TableColumn tableColumn = (TableColumn)this.tableColumns.get(index);
        tableColumn.setPreferredWidth(width);
        tableColumn.setWidth(width);
    }

    public void setColumnTitle(String columnName, String columnTitle) throws IllegalArgumentException {
        if (StringUtility.isEmpty(columnName)) {
            return;
        }
        try {
            int columnIndex = this.getColumnIndex(columnName);
            this.setColumnTitle(columnIndex, columnTitle);
        }
        catch (IllegalArgumentException e) {
            if (this.columnTitles == null) {
                this.columnTitles = new HashMap();
            }
            this.columnTitles.put(columnName, columnTitle);
        }
    }

    public void setColumnTitle(int index, String columnTitle) throws ArrayIndexOutOfBoundsException {
        TableColumn tableColumn = (TableColumn)this.tableColumns.get(index);
        tableColumn.setHeaderValue(columnTitle);
    }

    public ArrayList<String> getColumnTitles() {
        ArrayList<String> titles = new ArrayList<String>(this.tableColumns.size());
        for (TableColumn tc : this.tableColumns) {
            titles.add(tc.getHeaderValue().toString());
        }
        return titles;
    }

    public void hideColumns(Collection<String> columnNames) {
        if (CollectionUtility.isEmpty(columnNames)) {
            return;
        }
        this.hideColumns(columnNames.toArray(new String[0]));
    }

    public void hideColumns(String ... columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            return;
        }
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.hideColumn(columnName);
            ++n2;
        }
    }

    public void hideColumn(String columnName) {
        TableColumn columnToHide = null;
        for (TableColumn tc : this.tableColumns) {
            if (!tc.getIdentifier().equals(columnName)) continue;
            columnToHide = tc;
            break;
        }
        if (columnToHide == null) {
            if (this.hiddenColumnNames == null) {
                this.hiddenColumnNames = new ArrayList();
            }
            this.hiddenColumnNames.add(columnName);
            return;
        }
        this.hideColumn(columnToHide);
    }

    public void hideColumn(TableColumn tableColumn) {
        if (tableColumn == null) {
            return;
        }
        if (this.hiddenColumns == null) {
            this.hiddenColumns = new ArrayList();
        }
        if (this.tableColumns.contains(tableColumn)) {
            this.tableColumns.remove(tableColumn);
            this.hiddenColumns.add(tableColumn);
        }
    }

    public void showColumns(String ... columnNames) {
        if (CollectionUtility.isEmpty(this.hiddenColumnNames) || ArrayUtility.isEmpty(columnNames)) {
            return;
        }
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.showColumn(columnName);
            ++n2;
        }
    }

    public void showColumn(String columnName) {
        if (CollectionUtility.isEmpty(this.hiddenColumnNames) || columnName == null) {
            return;
        }
        TableColumn columnToShow = null;
        for (TableColumn tc : this.hiddenColumns) {
            if (!tc.getIdentifier().equals(columnName)) continue;
            columnToShow = tc;
            break;
        }
        if (columnToShow == null) {
            return;
        }
        this.showColumn(columnToShow);
    }

    public void showColumn(TableColumn tableColumn) {
        if (CollectionUtility.isEmpty(this.hiddenColumnNames) || tableColumn == null) {
            return;
        }
        if (this.hiddenColumns.contains(tableColumn)) {
            this.hiddenColumns.remove(tableColumn);
            this.tableColumns.add(tableColumn);
        }
    }

    public void setColumnOrder(Collection<String> columnNames) {
        if (CollectionUtility.isEmpty(columnNames)) {
            return;
        }
        String[] cNames = columnNames.toArray(new String[0]);
        this.setColumnOrder(cNames);
    }

    public void setColumnOrder(String ... columnNames) {
        if (ArrayUtility.isEmpty(columnNames)) {
            return;
        }
        this.preferredColumnOrder = columnNames;
        int currentColumnCount = this.tableColumns.size();
        Object[] tableColumns = new TableColumn[currentColumnCount];
        this.tableColumns.copyInto(tableColumns);
        this.tableColumns.clear();
        String[] stringArray = columnNames;
        int n = columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            int i = 0;
            while (i < tableColumns.length) {
                if (tableColumns[i] != null && ((TableColumn)tableColumns[i]).getIdentifier().equals(columnName)) {
                    this.tableColumns.addElement(tableColumns[i]);
                    tableColumns[i] = null;
                    break;
                }
                ++i;
            }
            ++n2;
        }
        int i = 0;
        while (i < tableColumns.length) {
            if (tableColumns[i] != null) {
                this.tableColumns.addElement(tableColumns[i]);
            }
            ++i;
        }
    }

    public void reset() {
        if (this.hiddenColumns != null) {
            this.hiddenColumns.clear();
        }
        if (this.tableColumns != null) {
            this.tableColumns.clear();
        }
    }

    public void showTableColumns() {
        int i = 0;
        while (i < this.getColumnCount()) {
            TableColumn tc = this.getColumn(i);
            System.out.printf("DynamicBeanColumnModel.showTableColumns(): cn=%d modelIndex=%d columnName=%s\n", i, tc.getModelIndex(), tc.getIdentifier());
            ++i;
        }
    }
}

