/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.swing.table.OutputStreamTableModelExport;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Time;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelTableModelExport
extends OutputStreamTableModelExport {
    private String worksheetName;

    public ExcelTableModelExport(JTable table) {
        super(table);
        this.setWorksheetName(null);
    }

    public ExcelTableModelExport(TableModel tableModel) {
        super(tableModel);
        this.setWorksheetName(null);
    }

    public String getWorksheetName() {
        return this.worksheetName;
    }

    public void setWorksheetName(String worksheetName) {
        if (worksheetName == null) {
            worksheetName = "Excel Export";
        }
        this.worksheetName = worksheetName;
    }

    @Override
    public void export() {
        TableModel tableModel = this.getTableModel();
        if (tableModel == null) {
            throw new IllegalStateException(this.getClass().getName() + " does not have a reference to a table to export.");
        }
        HSSFWorkbook workBook = new HSSFWorkbook();
        HSSFSheet sheet = workBook.createSheet(this.worksheetName);
        HSSFRow headerRow = sheet.createRow(0);
        int columns = this.getColumnCount();
        int c = 0;
        while (c < columns) {
            String columnName = this.getColumnName(c);
            HSSFCell cell = headerRow.createCell(c);
            cell.setCellValue(new HSSFRichTextString(columnName));
            ++c;
        }
        int rows = this.getRowCount();
        int r = 0;
        while (r < rows) {
            HSSFRow row = sheet.createRow(r + 1);
            int c2 = 0;
            while (c2 < columns) {
                HSSFCell cell = row.createCell(c2);
                Object value = tableModel.getValueAt(r, c2);
                if (value == null) {
                    value = "";
                }
                if (value instanceof Number) {
                    cell.setCellValue(((Number)value).doubleValue());
                } else if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                } else if (value instanceof com.jmorgan.util.Date) {
                    cell.setCellValue(((com.jmorgan.util.Date)value).getCalendar());
                } else if (value instanceof Time) {
                    cell.setCellValue(((Time)value).getCalendar());
                } else if (value instanceof DateTime) {
                    cell.setCellValue(((DateTime)value).getCalendar());
                } else if (value instanceof Boolean) {
                    cell.setCellValue((Boolean)value);
                } else if (value instanceof Calendar) {
                    cell.setCellValue((Calendar)value);
                } else if (value instanceof String || value instanceof StringBuilder || value instanceof StringBuffer) {
                    cell.setCellValue(new HSSFRichTextString(value.toString()));
                } else {
                    System.out.println("ExcelTableModelExport.export(): Warning:  Column class of " + value.getClass().getName() + " is not handled by ExcelTableModelExport.export()");
                    Object strValue = value.toString();
                    if (((String)strValue).length() > 300) {
                        strValue = ((String)strValue).substring(0, 300) + "...";
                    }
                    cell.setCellValue((String)strValue);
                }
                ++c2;
            }
            ++r;
        }
        try {
            OutputStream outputStream = this.getOutputStream();
            workBook.write(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

