/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.DateField;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.TimeField;
import com.jmorgan.swing.combobox.DateComboBox;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.ModifyingTableCellRenderer;
import com.jmorgan.swing.table.TableCellBooleanRendererEditor;
import com.jmorgan.swing.table.TableCellRenderingHelper;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.text.NumericalRangeValidator;
import com.jmorgan.text.Validator;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableCellEditorRenderer
implements TableCellEditor,
TableCellRenderer {
    private String nullDisplayValue = "";
    private final JLabel DEFAULT_RENDERER = new JLabel();
    private final JTextField DEFAULT_EDITOR;
    private HashMap<Class<?>, Object> typedRenderers;
    private HashMap<Class<?>, Object> typedEditors;
    private HashMap<Pair<Integer, Integer>, Object> specificRenderers;
    private HashMap<Pair<Integer, Integer>, Object> specificEditors;
    private ArrayList<ModifyingTableCellRenderer> modifyingRenderers;
    private HashMap<Pair<Integer, Integer>, Validator> validators;
    private Object nullRenderer;
    private Object nullEditor;
    private Object currentEditor;
    private Class<?> currentType;
    private CopyOnWriteArrayList<CellEditorListener> cellEditorListeners;

    public TableCellEditorRenderer() {
        this.DEFAULT_RENDERER.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.DEFAULT_EDITOR = new JTextField();
        this.DEFAULT_EDITOR.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.typedRenderers = new HashMap();
        this.typedEditors = new HashMap();
        this.specificRenderers = new HashMap();
        this.specificEditors = new HashMap();
        this.validators = new HashMap();
        this.nullRenderer = new JLabel(this.nullDisplayValue);
        this.nullEditor = new JTextField();
    }

    public String getNullDisplayValue() {
        return this.nullDisplayValue;
    }

    public void setNullDisplayValue(String nullDisplayValue) {
        this.nullDisplayValue = nullDisplayValue;
    }

    public JComponent getNullRenderer() {
        if (this.nullRenderer == null) {
            return null;
        }
        if (this.nullRenderer instanceof JComponent) {
            return (JComponent)this.nullRenderer;
        }
        if (this.nullRenderer instanceof TableCellRenderer) {
            TableCellRenderer renderer = (TableCellRenderer)this.nullRenderer;
            JComponent c = (JComponent)renderer.getTableCellRendererComponent(null, null, false, false, 0, 0);
            return c;
        }
        return this.DEFAULT_RENDERER;
    }

    public void setNullRenderer(JComponent component) {
        if (component == null) {
            return;
        }
        this.nullRenderer = component;
    }

    public void setNullRenderer(TableCellRenderer renderer) {
        if (renderer == null) {
            return;
        }
        this.nullRenderer = renderer;
    }

    public JComponent getNullEditor() {
        if (this.nullEditor == null) {
            return null;
        }
        if (this.nullEditor instanceof JComponent) {
            return (JComponent)this.nullEditor;
        }
        if (this.nullEditor instanceof TableCellRenderer) {
            TableCellRenderer renderer = (TableCellRenderer)this.nullEditor;
            JComponent c = (JComponent)renderer.getTableCellRendererComponent(null, null, false, false, 0, 0);
            return c;
        }
        return this.DEFAULT_EDITOR;
    }

    public void setNullEditor(JComponent component) {
        if (component == null) {
            return;
        }
        this.nullEditor = component;
    }

    public void setNullEditor(TableCellRenderer renderer) {
        if (renderer == null) {
            return;
        }
        this.nullEditor = renderer;
    }

    public void addModifyingRenderer(ModifyingTableCellRenderer modifyingRenderer) {
        if (modifyingRenderer == null) {
            return;
        }
        if (this.modifyingRenderers == null) {
            this.modifyingRenderers = new ArrayList();
        }
        this.modifyingRenderers.add(modifyingRenderer);
    }

    public void setRenderer(Class<?> type, JComponent renderer) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("The type parameter cannot be null in TableCellEditorRenderer.setRenderer(Class<?> type, JComponent renderer).");
        }
        this.typedRenderers.put(type, renderer);
    }

    public void setRenderer(int column, JComponent renderer) {
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorRenderer.setRenderer(int column, JComponent renderer) must be greater than or equal to zero.");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("The renderer parameter cannot be null in TableCellEditorRenderer.setRenderer(int column, JComponent renderer).");
        }
        this.setRenderer(-1, column, renderer);
    }

    public void setRenderer(int row, int column, JComponent renderer) {
        if (row < 0) {
            throw new IllegalArgumentException("The row parameter in TableCellEditorRenderer.setRenderer(int row, int column, JComponent renderer) must be greater than or equal to zero.");
        }
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorRenderer.setRenderer(int column, JComponent renderer) must be greater than or equal to zero.");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("The renderer parameter cannot be null in TableCellEditorRenderer.setRenderer(int column, JComponent renderer).");
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        this.specificEditors.put(index, renderer);
    }

    public void setRenderer(Class<?> type, TableCellRenderer renderer) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("The type parameter cannot be null in TableCellEditorRenderer.setRenderer(Class<?> type, TableCellRenderer renderer).");
        }
        this.typedRenderers.put(type, renderer);
    }

    public void setRenderer(int column, TableCellRenderer renderer) {
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorRenderer.setRenderer(int column, TableCellRenderer renderer) must be greater than or equal to zero.");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("The renderer parameter cannot be null in TableCellEditorRenderer.setRenderer(int column, TableCellRenderer renderer).");
        }
        this.setRenderer(-1, column, renderer);
    }

    public void setRenderer(int row, int column, TableCellRenderer renderer) {
        if (row < 0) {
            throw new IllegalArgumentException("The row parameter in TableCellEditorRenderer.setRenderer(int row, int column, TableCellRenderer renderer) must be greater than or equal to zero.");
        }
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorRenderer.setRenderer(int column, TableCellRenderer renderer) must be greater than or equal to zero.");
        }
        if (renderer == null) {
            throw new IllegalArgumentException("The renderer parameter cannot be null in TableCellEditorRenderer.setRenderer(int column, TableCellRenderer renderer).");
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        this.specificRenderers.put(index, renderer);
    }

    public void setEditor(Class<?> type, JComponent editor) {
        if (type == null) {
            throw new IllegalArgumentException("The type parameter cannot be null in TableCellEditorRenderer.setEditor(Class<?> type, JComponent editor).");
        }
        this.typedRenderers.put(type, editor);
    }

    public void setEditor(int column, JComponent editor) {
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorEditor.setEditor(int column, JComponent editor) must be greater than or equal to zero.");
        }
        if (editor == null) {
            throw new IllegalArgumentException("The editor parameter cannot be null in TableCellEditorEditor.setEditor(int column, JComponent editor).");
        }
        this.setEditor(-1, column, editor);
    }

    public void setEditor(int row, int column, JComponent editor) {
        if (row < 0) {
            throw new IllegalArgumentException("The row parameter in TableCellEditorEditor.setEditor(int row, int column, JComponent editor) must be greater than or equal to zero.");
        }
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorEditor.setEditor(int column, JComponent editor) must be greater than or equal to zero.");
        }
        if (editor == null) {
            throw new IllegalArgumentException("The editor parameter cannot be null in TableCellEditorEditor.setEditor(int column, JComponent editor).");
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        this.specificEditors.put(index, editor);
    }

    public void setEditor(Class<?> type, TableCellEditor editor) {
        if (type == null) {
            throw new IllegalArgumentException("The type parameter cannot be null in TableCellEditorRenderer.setEditor(Class<?> type, TableCellEditor editor).");
        }
        this.typedRenderers.put(type, editor);
    }

    public void setEditor(int column, TableCellEditor editor) {
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorEditor.setEditor(int column, TableCellEditor editor) must be greater than or equal to zero.");
        }
        if (editor == null) {
            throw new IllegalArgumentException("The editor parameter cannot be null in TableCellEditorEditor.setEditor(int column, TableCellEditor editor).");
        }
        this.setEditor(-1, column, editor);
    }

    public void setEditor(int row, int column, TableCellEditor editor) {
        if (row < 0) {
            throw new IllegalArgumentException("The row parameter in TableCellEditorEditor.setEditor(int row, int column, TableCellEditor editor) must be greater than or equal to zero.");
        }
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorEditor.setEditor(int column, TableCellEditor editor) must be greater than or equal to zero.");
        }
        if (editor == null) {
            throw new IllegalArgumentException("The editor parameter cannot be null in TableCellEditorEditor.setEditor(int column, TableCellEditor editor).");
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        this.specificEditors.put(index, editor);
    }

    public Validator getValidator(int row, int column) {
        Pair<Integer, Integer> cellIndex = new Pair<Integer, Integer>(row, column);
        Validator validator = this.validators.get(cellIndex);
        return validator;
    }

    public void setValidator(int row, int column, Validator validator) {
        if (row < 0) {
            throw new IllegalArgumentException("The row parameter in TableCellEditorEditor.setValidator(int row, int column, Validator validator) must be greater than or equal to zero.");
        }
        if (column < 0) {
            throw new IllegalArgumentException("The column parameter in TableCellEditorEditor.setValidator(int column, Validator validator) must be greater than or equal to zero.");
        }
        if (validator == null) {
            throw new IllegalArgumentException("The validator parameter cannot be null in TableCellEditorEditor.setValidator(int column, Validator validator).");
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        this.validators.put(index, validator);
    }

    @Override
    public Object getCellEditorValue() {
        Serializable value = null;
        if (this.currentEditor == null) {
            return null;
        }
        if (this.currentEditor instanceof TableCellBooleanRendererEditor) {
            value = ((TableCellBooleanRendererEditor)this.currentEditor).isSelected();
        } else if (this.currentEditor instanceof NumberSpinner) {
            NumberSpinner numberSpinner = (NumberSpinner)this.currentEditor;
            NumberField numberField = (NumberField)numberSpinner.getComponent();
            value = numberField.getNumber();
            Double dValue = (Double)value;
            if (this.currentType.equals(Byte.class)) {
                value = dValue.byteValue();
            } else if (this.currentType.equals(Character.class)) {
                value = Character.valueOf((char)dValue.intValue());
            } else if (this.currentType.equals(Short.class)) {
                value = dValue.shortValue();
            } else if (this.currentType.equals(Integer.class)) {
                value = dValue.intValue();
            } else if (this.currentType.equals(Long.class)) {
                value = dValue.longValue();
            } else if (this.currentType.equals(Float.class)) {
                value = Float.valueOf(dValue.floatValue());
            } else if (this.currentType.equals(BigInteger.class)) {
                value = BigInteger.valueOf(dValue.longValue());
            }
        } else if (this.currentEditor instanceof JTextField) {
            value = ((JTextField)this.currentEditor).getText();
        } else if (this.currentEditor instanceof DateComboBox) {
            value = ((DateComboBox)this.currentEditor).getDate();
        } else if (this.currentEditor instanceof JComboBox) {
            value = ((JComboBox)this.currentEditor).getSelectedItem();
        } else if (this.currentEditor instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)this.currentEditor;
            JMTable cellTable = (JMTable)scrollPane.getViewport().getView();
            TableModel tableModel = cellTable.getModel();
            if (tableModel instanceof BeanTableModel) {
                BeanTableModel beanTableModel = (BeanTableModel)tableModel;
                value = beanTableModel.getModelData();
            } else if (tableModel instanceof DynamicBeanTableModel) {
                DynamicBeanTableModel beanTableModel = (DynamicBeanTableModel)tableModel;
                beanTableModel.reset();
                value = beanTableModel.getModelData();
            }
        } else {
            System.err.printf("TableCellEditorRenderer.getCellEditorValue():  How do I get the value from %s editor\n.", this.currentEditor.getClass().getName());
        }
        return value;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        Object value = this.getCellEditorValue();
        JTable table = this.currentEditor instanceof Component ? (JTable)((Component)this.currentEditor).getParent() : null;
        int row = table == null ? -1 : table.getEditingRow();
        int col = table == null ? -1 : table.getEditingColumn();
        for (Pair<Integer, Integer> index : this.validators.keySet()) {
            Validator validator;
            boolean isValid;
            int indexRow = (Integer)index.first;
            int indexCol = (Integer)index.second;
            if (indexRow != row || indexCol != col || (isValid = (validator = this.validators.get(index)).isValid(value))) continue;
            String infoMessage = validator.getValidationInfo();
            String strValue = value.toString();
            String message = String.format("The value '%s' failed validation.\n\n%s", strValue, infoMessage);
            new JMMessageBox(null, "Validation Error", LabelUtility.wrapInHTML(message));
            return false;
        }
        if (this.cellEditorListeners != null) {
            for (CellEditorListener listener : this.cellEditorListeners) {
                ChangeEvent event = new ChangeEvent(this);
                listener.editingStopped(event);
            }
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (this.cellEditorListeners != null) {
            for (CellEditorListener listener : this.cellEditorListeners) {
                ChangeEvent event = new ChangeEvent(this);
                listener.editingCanceled(event);
            }
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.cellEditorListeners == null) {
            this.cellEditorListeners = new CopyOnWriteArrayList();
        }
        if (!this.cellEditorListeners.contains(listener)) {
            this.cellEditorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        if (listener == null || this.cellEditorListeners == null) {
            return;
        }
        CopyOnWriteArrayList<CellEditorListener> copyOnWriteArrayList = this.cellEditorListeners;
        synchronized (copyOnWriteArrayList) {
            this.cellEditorListeners.remove(listener);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Class type = value == null ? String.class : value.getClass();
        JComponent renderer = this.getSpecificRenderer(table, value, isSelected, hasFocus, row, column, type);
        if (value == null) {
            value = this.nullDisplayValue;
        }
        if (renderer == null) {
            if (this.isStringType(type)) {
                renderer = new JLabel(value.toString());
                renderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (this.isBooleanType(type)) {
                renderer = new TableCellBooleanRendererEditor();
            } else if (this.isIntegerType(type)) {
                renderer = new NumberField(0.0, "###0;-###0");
                renderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (this.isFloatType(type)) {
                renderer = new NumberField(0.0, "#0.0");
                renderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (this.isDateType(type)) {
                renderer = new DateField();
                renderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (type.equals(Time.class)) {
                renderer = new TimeField();
                renderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (type.equals(DateTime.class) || type.equals(Timestamp.class)) {
                renderer = new JLabel();
                renderer.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (type.equals(ArrayList.class)) {
                renderer = this.getTableRendererEditor(value);
            }
            this.typedRenderers.put(type, renderer);
        }
        if (renderer == null) {
            System.err.printf("TableCellEditorRenderer.getTableCellRendererComponent():  Unable to determine or allocate cell renderer for type %s\n\tvalue=%s, isSelected=%b, hasFocus=%b, row=%d, column=%d\n", type.getName(), value.getClass().getName(), isSelected, hasFocus, row, column);
            this.DEFAULT_RENDERER.setText(value.toString());
            renderer = this.DEFAULT_RENDERER;
        }
        TableCellRenderingHelper.renderComponent(renderer, isSelected, row);
        if (this.isStringType(type)) {
            ((JLabel)renderer).setText(value.toString());
        } else if (this.isBooleanType(type)) {
            boolean bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : ((Boolean)value).booleanValue();
            ((TableCellBooleanRendererEditor)renderer).setSelected(bValue);
        } else if (this.isIntegerType(type)) {
            long nValue = value instanceof BigInteger ? ((BigInteger)value).longValue() : ((Number)value).longValue();
            ((NumberField)renderer).setNumber(nValue);
        } else if (this.isFloatType(type)) {
            double nValue = value instanceof BigDecimal ? ((BigDecimal)value).doubleValue() : ((Number)value).doubleValue();
            ((NumberField)renderer).setNumber(nValue);
        } else if (this.isDateType(type)) {
            com.jmorgan.util.Date date = null;
            date = value instanceof Calendar ? new com.jmorgan.util.Date((Calendar)value) : (value instanceof java.util.Date ? new com.jmorgan.util.Date((java.util.Date)value) : (com.jmorgan.util.Date)value);
            ((DateField)renderer).setDate(date.getCalendar());
        } else if (type.equals(Time.class)) {
            if (value instanceof Time) {
                Time time = (Time)value;
                ((TimeField)renderer).setTime(time.getCalendar());
            }
        } else if (type.equals(DateTime.class) || type.equals(Timestamp.class)) {
            if (value instanceof Timestamp) {
                Timestamp timeStamp = (Timestamp)value;
                DateTime dateTime = new DateTime(timeStamp.getTime());
                ((JLabel)renderer).setText(dateTime.toString());
            } else if (value instanceof DateTime) {
                DateTime dateTime = (DateTime)value;
                ((JLabel)renderer).setText(dateTime.toString());
            }
        } else if (type.equals(ArrayList.class)) {
            JScrollPane scrollPane = (JScrollPane)renderer;
            this.updateTableRendererEditor(scrollPane, value);
        }
        if (CollectionUtility.isNotEmpty(this.modifyingRenderers)) {
            for (ModifyingTableCellRenderer modifyingRenderer : this.modifyingRenderers) {
                modifyingRenderer.setRenderingComponent(renderer);
                renderer = (JComponent)modifyingRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
        return renderer;
    }

    private JComponent getSpecificRenderer(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column, Class<?> type) {
        if (value == null) {
            return this.getNullRenderer();
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        Object renderingComponent = this.specificRenderers.get(index);
        if (renderingComponent == null) {
            index.setFirst(-1);
            renderingComponent = this.specificRenderers.get(index);
            if (renderingComponent == null) {
                renderingComponent = this.typedRenderers.get(type);
            }
        }
        if (renderingComponent != null) {
            if (renderingComponent instanceof JComponent) {
                return (JComponent)renderingComponent;
            }
            if (renderingComponent instanceof TableCellRenderer) {
                TableCellRenderer renderer = (TableCellRenderer)renderingComponent;
                return (JComponent)renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Class type = value == null ? String.class : value.getClass();
        JComponent editor = this.getSpecificEditor(table, value, isSelected, row, column, type);
        if (value == null) {
            value = this.nullDisplayValue;
        }
        if (editor == null) {
            if (this.isStringType(type)) {
                editor = new JTextField(value.toString());
                editor.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            } else if (this.isBooleanType(type)) {
                editor = new TableCellBooleanRendererEditor();
            } else if (this.isIntegerType(type)) {
                nf = new NumberField(0.0, "###0;-###0");
                nf.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
                new KeyEventInvoker((Object)nf, 402, this, "numberFieldKeyTyped");
                NumberSpinner ns = new NumberSpinner(nf);
                Pair<Integer, Integer> cellIndex = new Pair<Integer, Integer>(row, column);
                Validator validator = this.validators.get(cellIndex);
                if (validator != null && validator instanceof NumericalRangeValidator) {
                    NumericalRangeValidator nrv = (NumericalRangeValidator)validator;
                    double min = nrv.getMinimum().doubleValue();
                    double max = nrv.getMaximum().doubleValue();
                    ns.setSpinMinimum(min);
                    ns.setSpinMaximum(max);
                }
                editor = ns;
            } else if (this.isFloatType(type)) {
                nf = new NumberField(0.0, "#0.0");
                nf.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
                new KeyEventInvoker((Object)nf, 402, this, "numberFieldKeyTyped");
                NumberSpinner ns = new NumberSpinner(nf);
                editor = ns;
            } else if (this.isDateType(type)) {
                DateComboBox dcbx = new DateComboBox();
                editor = dcbx;
            } else if (type.equals(Time.class)) {
                TimeField timeField = new TimeField();
                editor = timeField;
            } else if (type.equals(ArrayList.class)) {
                editor = this.getTableRendererEditor(value);
            }
            this.typedEditors.put(type, editor);
        }
        if (editor == null) {
            System.err.printf("TableCellEditorRenderer.getTableCellEditorComponent():  Unable to determine or allocate cell editor.\n\tvalue=%s, isSelected=%b, row=%d, column=%d\n", value.getClass().getName(), isSelected, row, column);
            this.DEFAULT_EDITOR.setText(value.toString());
            editor = this.DEFAULT_EDITOR;
        }
        if (!(editor instanceof JComboBox)) {
            TableCellRenderingHelper.renderComponent(editor, isSelected, row);
        }
        if (this.isStringType(type)) {
            if (editor instanceof JTextField) {
                ((JTextField)editor).setText(value.toString());
            } else if (editor instanceof JComboBox) {
                ((JComboBox)editor).setSelectedItem(value.toString());
            }
        } else if (this.isBooleanType(type)) {
            boolean bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : ((Boolean)value).booleanValue();
            ((TableCellBooleanRendererEditor)editor).setSelected(bValue);
        } else if (this.isIntegerType(type) || this.isFloatType(type)) {
            long nValue = value instanceof BigInteger ? ((BigInteger)value).longValue() : ((Number)value).longValue();
            NumberField nf = (NumberField)((NumberSpinner)editor).getComponent();
            nf.setNumber(nValue);
        } else if (this.isDateType(type)) {
            com.jmorgan.util.Date date = null;
            date = value instanceof Calendar ? new com.jmorgan.util.Date((Calendar)value) : (value instanceof java.util.Date ? new com.jmorgan.util.Date((java.util.Date)value) : (com.jmorgan.util.Date)value);
            ((DateComboBox)editor).setDate(date);
        } else if (type.equals(Time.class)) {
            Time time = (Time)value;
            ((TimeField)editor).setTime(time.getCalendar());
        } else if (type.equals(ArrayList.class)) {
            JScrollPane scrollPane = (JScrollPane)editor;
            this.updateTableRendererEditor(scrollPane, value);
        }
        this.currentEditor = editor;
        this.currentType = type;
        return editor;
    }

    private boolean isStringType(Class<?> type) {
        return type.equals(String.class) || type.equals(StringBuffer.class) || type.equals(StringBuilder.class);
    }

    private boolean isBooleanType(Class<?> type) {
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    private boolean isIntegerType(Class<?> type) {
        return type.equals(Byte.class) || type.equals(Character.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(BigInteger.class);
    }

    private boolean isFloatType(Class<?> type) {
        return type.equals(Float.class) || type.equals(Double.class) || type.equals(BigDecimal.class);
    }

    private boolean isDateType(Class<?> type) {
        return type.equals(Calendar.class) || type.equals(java.util.Date.class) || type.equals(Date.class) || type.equals(com.jmorgan.util.Date.class);
    }

    private JScrollPane getTableRendererEditor(Object value) {
        ArrayList valueList = (ArrayList)value;
        Class<?> rowType = valueList.get(0).getClass();
        BeanTableModel cellTableModel = new BeanTableModel(rowType);
        BeanColumnModel cellColumnModel = new BeanColumnModel(cellTableModel);
        JMTable tableForCell = new JMTable(cellTableModel, cellColumnModel);
        return new JScrollPane(tableForCell);
    }

    private void updateTableRendererEditor(JScrollPane scrollPane, Object value) {
        ArrayList data = (ArrayList)value;
        JMTable cellTable = (JMTable)scrollPane.getViewport().getView();
        TableModel tableModel = cellTable.getModel();
        if (tableModel instanceof BeanTableModel) {
            beanTableModel = (BeanTableModel)tableModel;
            ((BeanTableModel)beanTableModel).reset();
            ((BeanTableModel)beanTableModel).addAll(data);
        } else if (tableModel instanceof DynamicBeanTableModel) {
            beanTableModel = (DynamicBeanTableModel)tableModel;
            ((DynamicBeanTableModel)beanTableModel).reset();
            ((DynamicBeanTableModel)beanTableModel).addAll(data);
        }
        cellTable.optimizeColumnWidths();
        int rowCount = data.size();
        int height = 20 + rowCount * 30;
        int width = scrollPane.getPreferredSize().width;
        Dimension size = new Dimension(width, height);
        scrollPane.setPreferredSize(size);
        scrollPane.setMinimumSize(size);
    }

    @Reflected
    private void numberFieldKeyTyped() {
        NumberSpinner ns = (NumberSpinner)this.currentEditor;
        NumberField nf = (NumberField)ns.getComponent();
        new AsynchMethodInvoker((Object)this, "forceNumberFieldValue", (Object)nf);
    }

    @Reflected
    private void forceNumberFieldValue(NumberField numberField) {
        String text = numberField.getText();
        if (StringUtility.isEmpty(text)) {
            numberField.setNumber(0.0);
        } else if (NumberUtility.isLong(text)) {
            numberField.setNumber(Integer.parseInt(text));
        } else {
            numberField.setNumber(Double.parseDouble(text));
        }
    }

    private JComponent getSpecificEditor(JTable table, Object value, boolean isSelected, int row, int column, Class<?> type) {
        if (value == null) {
            return this.getNullEditor();
        }
        Pair<Integer, Integer> index = new Pair<Integer, Integer>(row, column);
        Object editingObject = this.specificEditors.get(index);
        if (editingObject == null) {
            index.setFirst(-1);
            editingObject = this.specificEditors.get(index);
            if (editingObject == null) {
                editingObject = this.typedEditors.get(type);
            }
        }
        if (editingObject != null) {
            if (editingObject instanceof JComponent) {
                return (JComponent)editingObject;
            }
            if (editingObject instanceof TableCellEditor) {
                TableCellEditor editor = (TableCellEditor)editingObject;
                return (JComponent)editor.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        }
        return null;
    }
}

