/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text;

import com.jmorgan.swing.text.CharacterFilteringDocumentFilter;
import com.jmorgan.util.NumberUtility;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class PercentDocumentFilter
extends CharacterFilteringDocumentFilter {
    public PercentDocumentFilter() {
        super("0123456789.-+%");
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (!this.isStringAllowed(string)) {
            return;
        }
        String newText = this.getNewString(fb.getDocument().getText(0, fb.getDocument().getLength()), offset, fb.getDocument().getLength(), string);
        if (!NumberUtility.isNumber(newText = newText.replaceAll("%", ""))) {
            return;
        }
        super.insertString(fb, offset, string, attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (!this.isStringAllowed(text)) {
            return;
        }
        String newText = this.getNewString(fb.getDocument().getText(0, fb.getDocument().getLength()), offset, length, text);
        if (!NumberUtility.isNumber(newText = newText.replaceAll("%", ""))) {
            return;
        }
        super.replace(fb, offset, length, text, attrs);
    }
}

