/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.Token;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import com.jmorgan.swing.text.editor.util.JarServiceProvider;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.text.JTextComponent;

public class MapCompletionAction
extends DefaultSyntaxAction {
    Map<String, String> completions;

    public MapCompletionAction() {
        super("MAP_COMPLETION");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        String abbriv;
        Token token = sDoc.getTokenAt(dot);
        if (token != null && this.completions.containsKey(abbriv = ActionUtils.getTokenStringAt(sDoc, dot))) {
            String completed = this.completions.get(abbriv);
            if (completed.indexOf(124) >= 0) {
                int ofst = completed.length() - completed.indexOf(124) - 1;
                sDoc.replaceToken(token, completed.replace("|", ""));
                target.setCaretPosition(target.getCaretPosition() - ofst);
            } else {
                sDoc.replaceToken(token, completed);
            }
        }
    }

    public void setCompletionsFile(String value) {
        this.completions = JarServiceProvider.readStringsMap(value);
    }
}

