/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import com.jmorgan.swing.text.editor.util.Configuration;
import com.jmorgan.swing.text.editor.util.JarServiceProvider;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;

public class ScriptAction
extends DefaultSyntaxAction {
    static final String SCRIPT_FUNCTION = "SCRIPT_FUNCTION";
    static final ScriptEngine engine = new ScriptEngineManager().getEngineByExtension("js");
    static final Invocable invocable = (Invocable)((Object)engine);

    public ScriptAction() {
        super("scripted-action");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        if (this.getValue(SCRIPT_FUNCTION) != null) {
            String f = this.getValue(SCRIPT_FUNCTION).toString();
            try {
                engine.put("TARGET", target);
                engine.put("SDOC", sDoc);
                engine.put("DOT", dot);
                engine.put("EVENT", e);
                engine.put("ACTION", this);
                engine.put("AU", ActionUtils.getInstance());
                invocable.invokeFunction(f, new Object[0]);
            }
            catch (ScriptException ex) {
                this.showScriptError(target, ex);
            }
            catch (NoSuchMethodException ex) {
                this.showScriptError(target, ex);
            }
        } else {
            JOptionPane.showMessageDialog(target, ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptAction.NoScriptConfigured"), ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptAction.ErrorInScript"), 2);
        }
    }

    public void setFunction(String name) {
        this.putValue(SCRIPT_FUNCTION, name);
    }

    @Override
    public void install(JEditorPane editor, Configuration config, String name) {
        super.install(editor, config, name);
        for (Configuration.StringKeyMatcher m : config.getKeys(Pattern.compile("Script\\.((\\w|-)+)\\.URL"))) {
            this.getScriptFromURL(m.value);
        }
    }

    public void getScriptFromURL(String url) {
        InputStream is = JarServiceProvider.findResource(url, this.getClass().getClassLoader());
        if (is != null) {
            InputStreamReader reader = new InputStreamReader(is);
            try {
                engine.eval(reader);
            }
            catch (ScriptException ex) {
                this.showScriptError(null, ex);
            }
        } else {
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptAction.NoScriptFoundIn") + url, ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptAction.ErrorInScript"), 2);
        }
    }

    private void showScriptError(JTextComponent target, Exception ex) {
        JOptionPane.showMessageDialog(target, ex.getMessage(), ResourceBundle.getBundle("com.jmorgan.swing.text.editor/Bundle").getString("ScriptAction.ErrorInScript"), 2);
    }
}

