/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions;

import com.jmorgan.swing.text.editor.DefaultSyntaxKit;
import com.jmorgan.swing.text.editor.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;

public class ToggleComponentAction
extends DefaultSyntaxAction {
    private String componentName;

    public ToggleComponentAction() {
        super("toggle-component");
        this.putValue("SwingSelectedKey", Boolean.TRUE);
    }

    public void setComponent(String name) {
        this.componentName = name;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.componentName + ")";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target instanceof JEditorPane) {
            JEditorPane jEditorPane = (JEditorPane)target;
            DefaultSyntaxKit kit = (DefaultSyntaxKit)jEditorPane.getEditorKit();
            boolean status = kit.toggleComponent(jEditorPane, this.componentName);
            this.putValue("SwingSelectedKey", status);
        }
    }
}

