/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions.gui;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.text.editor.actions.DocumentSearchData;
import com.jmorgan.swing.text.editor.actions.gui.EscapeListener;
import com.jmorgan.swing.text.editor.components.Markers;
import com.jmorgan.swing.text.editor.util.SwingUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class QuickFindDialog
extends JDialog
implements DocumentListener,
EscapeListener {
    private static String artRoot;
    private JMButton jBtnNext;
    private JMButton jBtnPrev;
    private JMCheckBox jChkIgnoreCase;
    private JMCheckBox jChkRegExp;
    private JMCheckBox jChkWrap;
    private JLabel jLabel1;
    private JLabel jLblStatus;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToolBar jToolBar1;
    private JTextField jTxtFind;
    private final Markers.SimpleMarker marker = new Markers.SimpleMarker(Color.PINK);
    private WeakReference<JTextComponent> target;
    private final WeakReference<DocumentSearchData> dsd;
    private int oldCaretPosition;
    private boolean escaped = false;

    static {
        GUIApplication appManager = GUIApplication.getGUIApplication();
        artRoot = appManager == null ? "/resources/" : String.format("/%s", appManager.getArtRoot());
    }

    public QuickFindDialog(JTextComponent target, DocumentSearchData data) {
        super(SwingUtilities.getWindowAncestor(target), Dialog.ModalityType.MODELESS);
        this.initComponents();
        SwingUtils.addEscapeListener(this);
        this.dsd = new WeakReference<DocumentSearchData>(data);
    }

    public void showFor(final JTextComponent target) {
        this.oldCaretPosition = target.getCaretPosition();
        Container view = target.getParent();
        Dimension wd = this.getSize();
        wd.width = target.getVisibleRect().width;
        Point loc = new Point(0, view.getHeight());
        this.setSize(wd);
        this.setLocationRelativeTo(view);
        SwingUtilities.convertPointToScreen(loc, view);
        this.setLocation(loc);
        this.jTxtFind.setFont(target.getFont());
        this.jTxtFind.getDocument().addDocumentListener(this);
        WindowAdapter closeListener = new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                target.getDocument().removeDocumentListener(QuickFindDialog.this);
                Markers.removeMarkers(target, QuickFindDialog.this.marker);
                if (QuickFindDialog.this.escaped) {
                    try {
                        Rectangle aRect = target.modelToView(QuickFindDialog.this.oldCaretPosition);
                        target.setCaretPosition(QuickFindDialog.this.oldCaretPosition);
                        target.scrollRectToVisible(aRect);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                QuickFindDialog.this.dispose();
            }
        };
        this.addWindowListener(closeListener);
        this.target = new WeakReference<JTextComponent>(target);
        Pattern p = ((DocumentSearchData)this.dsd.get()).getPattern();
        if (p != null) {
            this.jTxtFind.setText(p.pattern());
        }
        this.jChkWrap.setSelected(((DocumentSearchData)this.dsd.get()).isWrap());
        this.setVisible(true);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jSeparator1 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JToolBar.Separator();
        this.jTxtFind = new JTextField();
        this.jSeparator3 = new JToolBar.Separator();
        this.jBtnPrev = new JMButton(new ImageIcon(GUIApplication.getMenuResource(artRoot, "Up.png")));
        this.jBtnNext = new JMButton(new ImageIcon(GUIApplication.getMenuResource(artRoot, "Down.png")));
        this.jChkIgnoreCase = new JMCheckBox("Ignore &Case");
        this.jChkRegExp = new JMCheckBox("&Reg Exp");
        this.jChkWrap = new JMCheckBox("&Wrap");
        this.jSeparator4 = new JToolBar.Separator();
        this.jLblStatus = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.darkGray);
        this.setName("QuickFindDialog");
        this.setUndecorated(true);
        this.setResizable(false);
        this.jToolBar1.setBorder(BorderFactory.createEtchedBorder());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.add(this.jSeparator1);
        this.jLabel1.setLabelFor(this.jTxtFind);
        this.jLabel1.setText("Quick Find");
        this.jToolBar1.add(this.jLabel1);
        this.jToolBar1.add(this.jSeparator2);
        this.jTxtFind.setColumns(30);
        this.jTxtFind.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jTxtFind.setMaximumSize(new Dimension(200, 24));
        this.jTxtFind.setMinimumSize(new Dimension(60, 24));
        this.jToolBar1.add(this.jTxtFind);
        this.jToolBar1.add(this.jSeparator3);
        this.jBtnPrev.setFocusable(false);
        new ActionEventInvoker(this.jBtnPrev, this, "findPrevious");
        this.jToolBar1.add(this.jBtnPrev);
        this.jBtnNext.setFocusable(false);
        new ActionEventInvoker(this.jBtnNext, this, "findNext");
        this.jToolBar1.add(this.jBtnNext);
        this.jChkIgnoreCase.setFocusable(false);
        new ActionEventInvoker(this.jChkIgnoreCase, this, "updateFind");
        this.jToolBar1.add(this.jChkIgnoreCase);
        this.jChkRegExp.setFocusable(false);
        new ActionEventInvoker(this.jChkIgnoreCase, this, "updateFind");
        this.jToolBar1.add(this.jChkRegExp);
        this.jChkWrap.setFocusable(false);
        new ActionEventInvoker(this.jChkWrap, this, "updateFind");
        this.jToolBar1.add(this.jChkWrap);
        this.jToolBar1.add(this.jSeparator4);
        this.jLblStatus.setFont(this.jLblStatus.getFont().deriveFont(this.jLblStatus.getFont().getStyle() | 1, this.jLblStatus.getFont().getSize() - 2));
        this.jLblStatus.setForeground(Color.red);
        this.jToolBar1.add(this.jLblStatus);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 684, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -2, -1, -2));
        this.pack();
    }

    @Reflected
    private void findNext() {
        if (((DocumentSearchData)this.dsd.get()).doFindNext((JTextComponent)this.target.get())) {
            this.jLblStatus.setText(null);
        } else {
            this.jLblStatus.setText("Not Found");
        }
    }

    @Reflected
    private void findPrevious() {
        if (((DocumentSearchData)this.dsd.get()).doFindPrev((JTextComponent)this.target.get())) {
            this.jLblStatus.setText(null);
        } else {
            this.jLblStatus.setText("Not Found");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateFind();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateFind();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateFind();
    }

    private void updateFind() {
        JTextComponent t = (JTextComponent)this.target.get();
        DocumentSearchData d = (DocumentSearchData)this.dsd.get();
        String toFind = this.jTxtFind.getText();
        if (toFind == null || toFind.isEmpty()) {
            this.jLblStatus.setText(null);
            return;
        }
        try {
            d.setWrap(this.jChkWrap.isSelected());
            d.setPattern(toFind, this.jChkRegExp.isSelected(), this.jChkIgnoreCase.isSelected());
            this.jLblStatus.setText(null);
            t.setCaretPosition(this.oldCaretPosition);
            if (!d.doFindNext(t)) {
                this.jLblStatus.setText("Not Found");
            } else {
                this.jLblStatus.setText(null);
            }
        }
        catch (PatternSyntaxException e) {
            this.jLblStatus.setText(e.getDescription());
        }
    }

    @Override
    public void escapePressed() {
        this.escaped = true;
        this.setVisible(false);
    }
}

