/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.components;

import com.jmorgan.swing.text.editor.Token;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class Markers {
    private static final Logger LOG = Logger.getLogger(Markers.class.getName());

    public static void removeMarkers(JTextComponent component, SimpleMarker marker) {
        Highlighter hilite = component.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        int i = 0;
        while (i < hilites.length) {
            if (hilites[i].getPainter() instanceof SimpleMarker) {
                SimpleMarker hMarker = (SimpleMarker)hilites[i].getPainter();
                if (marker == null || hMarker.equals(marker)) {
                    hilite.removeHighlight(hilites[i]);
                }
            }
            ++i;
        }
    }

    public static void removeMarkers(JTextComponent editorPane) {
        Markers.removeMarkers(editorPane, null);
    }

    public static void markToken(JTextComponent pane, Token token, SimpleMarker marker) {
        Markers.markText(pane, token.start, token.end(), marker);
    }

    public static void markText(JTextComponent pane, int start, int end, SimpleMarker marker) {
        try {
            Highlighter hiliter = pane.getHighlighter();
            int selStart = pane.getSelectionStart();
            int selEnd = pane.getSelectionEnd();
            if (selStart == selEnd || end < selStart || start > selStart) {
                hiliter.addHighlight(start, end, marker);
                return;
            }
            if (selStart > start && selStart < end) {
                hiliter.addHighlight(start, selStart, marker);
            }
            if (selEnd > start && selEnd < end) {
                hiliter.addHighlight(selEnd, end, marker);
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void markAll(JTextComponent pane, Pattern pattern, SimpleMarker marker) {
        sDoc = ActionUtils.getSyntaxDocument(pane);
        if (sDoc == null || pattern == null) {
            return;
        }
        matcher = sDoc.getMatcher(pattern);
        if (matcher != null) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            Markers.markText(pane, matcher.start(), matcher.end(), marker);
lbl8:
            // 2 sources

            ** while (matcher.find())
        }
lbl9:
        // 1 sources

    }

    public static class SimpleMarker
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SimpleMarker(Color color) {
            super(color);
        }
    }
}

