/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.components;

import com.jmorgan.swing.text.editor.SyntaxDocument;
import com.jmorgan.swing.text.editor.Token;
import com.jmorgan.swing.text.editor.actions.ActionUtils;
import com.jmorgan.swing.text.editor.components.Markers;
import com.jmorgan.swing.text.editor.components.SyntaxComponent;
import com.jmorgan.swing.text.editor.util.Configuration;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class PairsMarker
implements CaretListener,
SyntaxComponent,
PropertyChangeListener {
    public static final String PROPERTY_COLOR = "PairMarker.Color";
    private JTextComponent pane;
    private Markers.SimpleMarker marker;
    private SyntaxComponent.Status status;

    @Override
    public void caretUpdate(CaretEvent e) {
        this.removeMarkers();
        int pos = e.getDot();
        SyntaxDocument doc = ActionUtils.getSyntaxDocument(this.pane);
        Token token = doc.getTokenAt(pos);
        if (token != null && token.pairValue != 0) {
            Markers.markToken(this.pane, token, this.marker);
            Token other = doc.getPairFor(token);
            if (other != null) {
                Markers.markToken(this.pane, other, this.marker);
            }
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers(this.pane, this.marker);
    }

    @Override
    public void config(Configuration config) {
        Color markerColor = config.getColor(PROPERTY_COLOR, new Color(0xEEEE33));
        this.marker = new Markers.SimpleMarker(markerColor);
    }

    @Override
    public void install(JEditorPane editor) {
        this.pane = editor;
        this.pane.addCaretListener(this);
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    @Override
    public void deinstall(JEditorPane editor) {
        this.status = SyntaxComponent.Status.DEINSTALLING;
        this.pane.removeCaretListener(this);
        this.removeMarkers();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            this.pane.removeCaretListener(this);
            if (this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                this.pane.addCaretListener(this);
                this.removeMarkers();
            }
        }
    }
}

