/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;

public class ComponentConnector
extends JComponent
implements ComponentListener,
ContainerListener {
    public static final int SYMBOL_TYPE_NONE = 0;
    public static final int SYMBOL_TYPE_CIRCLE = 1;
    public static final int SYMBOL_TYPE_SQUARE = 2;
    private JComponent start;
    private JComponent end;
    private Color lineColor;
    private Color hoverColor;
    private Container parent;
    private boolean shouldPaint = true;
    private int connectorStartSymbolType;
    private int connectorEndSymbolType;

    public ComponentConnector() {
        this(null, null);
    }

    public ComponentConnector(JComponent start, JComponent end) {
        this(start, end, Color.BLACK, Color.ORANGE);
    }

    public ComponentConnector(JComponent start, JComponent end, Color lineColor, Color hoverColor) {
        this.setStart(start);
        this.setEnd(end);
        this.setLineColor(lineColor);
        this.setHoverColor(hoverColor);
    }

    public JComponent getStart() {
        return this.start;
    }

    public void setStart(JComponent start) {
        if (this.start != null && start == null) {
            this.dispose();
        }
        this.start = start;
        if (this.start != null) {
            this.start.addComponentListener(this);
        }
    }

    public JComponent getEnd() {
        return this.end;
    }

    public void setEnd(JComponent end) {
        if (this.end != null && end == null) {
            this.dispose();
        }
        this.end = end;
        if (this.end != null) {
            this.setParent(this.end.getParent());
            this.end.addComponentListener(this);
        }
    }

    public int getConnectorStartSymbolType() {
        return this.connectorStartSymbolType;
    }

    public void setConnectorStartSymbolType(int connectorStartSymbolType) {
        switch (connectorStartSymbolType) {
            case 0: 
            case 1: 
            case 2: {
                this.connectorStartSymbolType = connectorStartSymbolType;
            }
        }
    }

    public int getConnectorEndSymbolType() {
        return this.connectorEndSymbolType;
    }

    public void setConnectorEndSymbolType(int connectorEndSymbolType) {
        switch (connectorEndSymbolType) {
            case 0: 
            case 1: 
            case 2: {
                this.connectorEndSymbolType = connectorEndSymbolType;
            }
        }
    }

    private void dispose() {
        if (this.end != null) {
            this.end.removeComponentListener(this);
            this.parent.remove(this.end);
            this.end = null;
        }
        if (this.start != null) {
            this.start.removeComponentListener(this);
            this.parent.remove(this.start);
            this.start = null;
        }
        this.parent.removeContainerListener(this);
        this.parent.removeComponentListener(this);
        this.parent.remove(this);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    private void setParent(Container parent) {
        if (this.parent != null) {
            this.parent.removeComponentListener(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addComponentListener(this);
            this.parent.addContainerListener(this);
            this.setBounds(0, 0, this.parent.getWidth(), this.parent.getHeight());
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        if (lineColor == null) {
            return;
        }
        this.lineColor = lineColor;
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        if (hoverColor == null) {
            return;
        }
        this.hoverColor = hoverColor;
    }

    @Override
    public void paint(Graphics g) {
        if (g == null || this.start == null || this.end == null || !this.shouldPaint) {
            return;
        }
        Rectangle startRect = this.start.getBounds();
        Rectangle endRect = this.end.getBounds();
        Point startPoint = new Point();
        Point startSymbolPoint = new Point();
        Point endPoint = new Point();
        Point endSymbolPoint = new Point();
        if (ComponentConnector.isAbove(startRect, endRect)) {
            startPoint.x = (int)startRect.getCenterX();
            startPoint.y = startRect.y;
            endPoint.x = (int)endRect.getCenterX();
            endPoint.y = (int)endRect.getMaxY();
            if (this.connectorStartSymbolType > 0) {
                startSymbolPoint.x = startPoint.x - 5;
                startSymbolPoint.y = startPoint.y - 10;
                startPoint.y -= 5;
            }
            if (this.connectorEndSymbolType > 0) {
                endSymbolPoint.x = endPoint.x - 5;
                endSymbolPoint.y = endPoint.y;
                endPoint.y += 5;
            }
        } else if (ComponentConnector.isBelow(startRect, endRect)) {
            startPoint.x = (int)startRect.getCenterX();
            startPoint.y = (int)startRect.getMaxY();
            endPoint.x = (int)endRect.getCenterX();
            endPoint.y = endRect.y;
            if (this.connectorStartSymbolType > 0) {
                startSymbolPoint.x = startPoint.x - 5;
                startSymbolPoint.y = startPoint.y;
                startPoint.y += 5;
            }
            if (this.connectorEndSymbolType > 0) {
                endSymbolPoint.x = endPoint.x - 5;
                endSymbolPoint.y = endPoint.y - 10;
                endPoint.y -= 5;
            }
        }
        if (ComponentConnector.isRightOf(startRect, endRect)) {
            startPoint.x = (int)startRect.getMaxX();
            startPoint.y = (int)startRect.getCenterY();
            endPoint.x = endRect.x;
            endPoint.y = (int)endRect.getCenterY();
            if (this.connectorStartSymbolType > 0) {
                startSymbolPoint.x = startPoint.x;
                startSymbolPoint.y = startPoint.y - 5;
                startPoint.x += 5;
            }
            if (this.connectorEndSymbolType > 0) {
                endSymbolPoint.x = endPoint.x - 10;
                endSymbolPoint.y = endPoint.y - 5;
                endPoint.x -= 5;
            }
        } else if (ComponentConnector.isLeftOf(startRect, endRect)) {
            startPoint.x = startRect.x;
            startPoint.y = (int)startRect.getCenterY();
            endPoint.x = (int)endRect.getMaxX();
            endPoint.y = (int)endRect.getCenterY();
            if (this.connectorStartSymbolType > 0) {
                startSymbolPoint.x = startPoint.x - 10;
                startSymbolPoint.y = startPoint.y - 5;
                startPoint.x -= 5;
            }
            if (this.connectorEndSymbolType > 0) {
                endSymbolPoint.x = endPoint.x;
                endSymbolPoint.y = endPoint.y - 5;
                endPoint.x += 5;
            }
        }
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
        if (this.connectorStartSymbolType > 0) {
            ComponentConnector.drawConnectorSymbol(this.connectorStartSymbolType, startSymbolPoint, g);
        }
        if (this.connectorEndSymbolType > 0) {
            ComponentConnector.drawConnectorSymbol(this.connectorEndSymbolType, endSymbolPoint, g);
        }
        g.setColor(oldColor);
    }

    private static void drawConnectorSymbol(int symbolType, Point location, Graphics g) {
        switch (symbolType) {
            case 1: {
                g.fillOval(location.x, location.y, 10, 10);
                break;
            }
            case 2: {
                g.fillRect(location.x, location.y, 10, 10);
            }
        }
    }

    private static boolean isRightOf(Rectangle startRect, Rectangle endRect) {
        return endRect.x > startRect.x + startRect.width;
    }

    private static boolean isLeftOf(Rectangle startRect, Rectangle endRect) {
        return endRect.x + endRect.width < startRect.x;
    }

    private static boolean isAbove(Rectangle startRect, Rectangle endRect) {
        return endRect.y + endRect.height < startRect.y;
    }

    private static boolean isBelow(Rectangle startRect, Rectangle endRect) {
        return endRect.y > startRect.y + startRect.height;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.shouldPaint = false;
        this.parent.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (e.getSource() == this.parent) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        this.parent.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.parent == null) {
            return;
        }
        if (e.getSource() == this.parent) {
            this.setBounds(0, 0, this.parent.getWidth(), this.parent.getHeight());
            return;
        }
        this.parent.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.shouldPaint = true;
        this.parent.repaint();
    }

    @Override
    public void componentAdded(ContainerEvent e) {
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (e.getComponent() == this.start || e.getComponent() == this.end) {
            this.dispose();
        }
    }
}

