/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.lang.AsynchMethodInvoker;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.JTextComponent;

public class FocusSelector
implements FocusListener {
    private JTextComponent requestor;
    private int caretPosition = -1;
    private int selectionStart = -1;
    private int selectionEnd = -1;

    public FocusSelector(JTextComponent requestor) {
        this.setRequestor(requestor);
    }

    public JTextComponent getRequestor() {
        return this.requestor;
    }

    public void setRequestor(JTextComponent requestor) {
        if (this.requestor != null) {
            this.requestor.removeFocusListener(this);
            this.resetSelectionState();
        }
        this.requestor = requestor;
        if (this.requestor != null) {
            this.requestor.addFocusListener(this);
        }
    }

    public void resetSelectionState() {
        this.caretPosition = -1;
        this.selectionStart = -1;
        this.selectionEnd = -1;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.requestor == null) {
            return;
        }
        String text = this.requestor.getText();
        int textLength = text.length();
        if (this.caretPosition > textLength) {
            this.caretPosition = textLength;
        }
        if (this.caretPosition == -1) {
            this.caretPosition = 0;
        }
        new AsynchMethodInvoker((Object)this.requestor, "setCaretPosition", (Object)new Integer(this.caretPosition), 75);
        if (this.selectionStart == -1) {
            new AsynchMethodInvoker((Object)this.requestor, "selectAll", 125);
        } else {
            new AsynchMethodInvoker((Object)this.requestor, "select", new Object[]{new Integer(this.selectionStart), new Integer(this.selectionEnd)}, 125);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.requestor == null) {
            return;
        }
        this.selectionStart = this.requestor.getSelectionStart();
        this.selectionEnd = this.requestor.getSelectionEnd();
        this.caretPosition = this.requestor.getCaretPosition();
    }
}

