/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public abstract class HoverController
extends MouseAdapter {
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void addComponent(Component component) {
        component.addMouseListener(this);
    }

    public void addComponent(Component component, boolean recursive) {
        this.addComponent(component);
        if (recursive && component instanceof Container) {
            Component[] contained;
            Container container = (Container)component;
            Component[] componentArray = contained = container.getComponents();
            int n = contained.length;
            int n2 = 0;
            while (n2 < n) {
                Component cc = componentArray[n2];
                this.addComponent(cc, true);
                ++n2;
            }
        }
    }

    public void addComponents(Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.addComponent(component);
            ++n2;
        }
    }

    public void removeComponent(Component component) {
        component.removeMouseListener(this);
    }

    public void removeComponents(Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            this.removeComponent(component);
            ++n2;
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        if (!this.enabled) {
            return;
        }
        Object obj = evt.getSource();
        if (obj instanceof Component) {
            Component comp = (Component)obj;
            this.mouseEntered(comp);
        }
    }

    public abstract void mouseEntered(Component var1);

    @Override
    public void mouseExited(MouseEvent evt) {
        if (!this.enabled) {
            return;
        }
        Object obj = evt.getSource();
        if (obj instanceof Component) {
            Component comp = (Component)obj;
            this.mouseExited(comp);
        }
    }

    public abstract void mouseExited(Component var1);
}

