/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import javax.swing.JProgressBar;

public class JProgressController
implements Runnable {
    private JProgressBar progressBar;
    private Thread thread;
    private boolean running = false;
    private int value = 0;
    private int updateFrequency = 100;

    public JProgressController(JProgressBar progressBar, int updateFreq) {
        this(progressBar);
        this.setUpdateFrequency(updateFreq);
    }

    public JProgressController(JProgressBar progressBar) {
        this.progressBar = progressBar;
        this.value = progressBar.getMinimum();
    }

    public void setValue(int v) {
        if (v < this.progressBar.getMinimum() || v > this.progressBar.getMaximum()) {
            return;
        }
        this.value = v;
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int inc) {
        this.setValue(this.progressBar.getValue() + inc);
    }

    public int getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(int freq) {
        if (freq < 0) {
            return;
        }
        this.updateFrequency = freq;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.running = false;
        this.thread.interrupt();
        this.thread = null;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            this.progressBar.setValue(this.value);
            try {
                Thread.sleep(this.updateFrequency);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.running = false;
    }
}

