/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.util.StringIndexer;
import com.jmorgan.util.StringUtility;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class LabelUtility {
    private static JComponent lastComponent;

    private LabelUtility() {
    }

    public static void parseLabel(JComponent c) {
        if (lastComponent == c) {
            return;
        }
        lastComponent = c;
        ParseProperties properties = LabelUtility.getLabelProperties(c);
        if (properties == null) {
            return;
        }
        c.setName(properties.actionCommand);
        if (c instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)c;
            if (properties.mnemonic != '\u0000') {
                button.setMnemonic(properties.mnemonic);
            }
            if (properties.label != null) {
                button.setText(properties.label);
                button.setActionCommand(properties.actionCommand);
            }
        }
        if (c instanceof JLabel) {
            JLabel jlabel = (JLabel)c;
            if (properties.mnemonic != '\u0000') {
                jlabel.setDisplayedMnemonic(properties.mnemonic);
            }
            if (properties.label != null) {
                jlabel.setText(properties.label);
            }
        }
    }

    public static String deriveActionCommand(JComponent c) {
        ParseProperties properties = LabelUtility.getLabelProperties(c);
        return properties.actionCommand;
    }

    private static ParseProperties getLabelProperties(JComponent c) {
        String label = "";
        if (c instanceof AbstractButton) {
            label = ((AbstractButton)c).getText();
        }
        if (c instanceof JLabel) {
            label = ((JLabel)c).getText();
        }
        return LabelUtility.parseLabelProperties(label);
    }

    public static ParseProperties parseLabelProperties(String s) {
        String label;
        int ampersandCount = 0;
        if (StringUtility.isEmpty(s) || s.equals("...")) {
            return null;
        }
        if (s.toLowerCase().trim().startsWith("<html>")) {
            return null;
        }
        ParseProperties parseProperties = new ParseProperties();
        int ampLoc = s.indexOf(38);
        if (ampLoc == -1) {
            Object actionCommand = StringUtility.getDisplayableTitle(s);
            actionCommand = Character.toLowerCase(((String)actionCommand).charAt(0)) + ((String)actionCommand).substring(1);
            parseProperties.actionCommand = StringUtility.removeAll((String)actionCommand, ". ");
            parseProperties.label = s;
            return parseProperties;
        }
        char[] ca = s.toCharArray();
        ampersandCount = StringIndexer.countCharacter(ca, '&');
        if (ampersandCount == 1 && ca[ca.length - 1] == '&') {
            return null;
        }
        if (ca[ca.length - 1] == '&') {
            --ampersandCount;
        }
        int dblAmp = StringIndexer.countStrings(s, "&&");
        char[] newC = new char[ca.length - (ampersandCount -= dblAmp)];
        int i = 0;
        int j = 0;
        while (i < ca.length) {
            if (i == ca.length - 1) {
                try {
                    newC[j] = ca[i];
                    break;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("LabelUtility.parseLabelProperties(String s):  Error processing String:\n" + s);
                    throw e;
                }
            }
            if (ca[i] == '&' && ca[i + 1] != '&') {
                parseProperties.mnemonic = ca[i + 1];
            } else {
                if (ca[i] == '&' && ca[i + 1] == '&') {
                    ++i;
                }
                newC[j++] = ca[i];
            }
            ++i;
        }
        parseProperties.label = label = new String(newC);
        parseProperties.actionCommand = label;
        return parseProperties;
    }

    public static String wrapInHTML(String string) {
        string = string.replaceAll("\r\n", "<br/>");
        string = string.replaceAll("\n\r", "<br/>");
        string = string.replaceAll("\n", "<br/>");
        string = string.replaceAll("\r", "<br/>");
        return String.format("<html><body>%s</html></body>", string);
    }

    public static class ParseProperties {
        public String label = null;
        public String actionCommand = null;
        public char mnemonic = '\u0000';
    }
}

