/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.swing.style.ColorStyle;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.swing.util.InputVerificationController;
import java.awt.Color;
import javax.swing.text.JTextComponent;

public class MatchingFieldVerificationController
implements InputVerificationController {
    private JTextComponent field1;
    private JTextComponent field2;
    private TextStyle notMatchingStyle;
    private TextStyle matchingStyle;

    public MatchingFieldVerificationController(JTextComponent field1, JTextComponent field2) {
        this.setField1(field1);
        this.setField2(field2);
        TextStyle matchStyle = TextStyle.getDefaultTextStyle("TextField");
        TextStyle notMatchStyle = TextStyle.getDefaultTextStyle("TextField");
        ColorStyle notMatchColors = notMatchStyle.getColor();
        Color fg = notMatchColors.getForeground();
        Color bg = notMatchColors.getBackground();
        notMatchColors.setBackground(fg);
        notMatchColors.setForeground(bg);
        this.setMatchingStyle(matchStyle);
        this.setNotMatchingStyle(notMatchStyle);
    }

    public MatchingFieldVerificationController(JTextComponent field1, JTextComponent field2, TextStyle matchingStyle, TextStyle notMatchingStyle) {
        this.setField1(field1);
        this.setField2(field2);
        this.setMatchingStyle(matchingStyle);
        this.setNotMatchingStyle(notMatchingStyle);
    }

    public TextStyle getNotMatchingStyle() {
        return this.notMatchingStyle;
    }

    public void setNotMatchingStyle(TextStyle notMatchingStyle) {
        this.notMatchingStyle = notMatchingStyle;
    }

    public TextStyle getMatchingStyle() {
        return this.matchingStyle;
    }

    public void setMatchingStyle(TextStyle matchingStyle) {
        this.matchingStyle = matchingStyle;
    }

    public JTextComponent getField1() {
        return this.field1;
    }

    public void setField1(JTextComponent field1) {
        this.field1 = field1;
        new KeyEventInvoker((Object)this.field1, 1, this, "verifyInput");
    }

    public JTextComponent getField2() {
        return this.field2;
    }

    public void setField2(JTextComponent field2) {
        this.field2 = field2;
        new KeyEventInvoker((Object)this.field2, 1, this, "verifyInput");
    }

    @Override
    public void verifyInput() {
        String text2;
        String text1 = this.field1.getText();
        if (text1.equals(text2 = this.field2.getText())) {
            MatchingFieldVerificationController.applyStyles(this.field1, this.matchingStyle);
            MatchingFieldVerificationController.applyStyles(this.field2, this.matchingStyle);
        } else {
            MatchingFieldVerificationController.applyStyles(this.field1, this.notMatchingStyle);
            MatchingFieldVerificationController.applyStyles(this.field2, this.notMatchingStyle);
        }
    }

    private static void applyStyles(JTextComponent field, TextStyle style) {
        field.setBackground(style.getColor().getBackground());
        field.setForeground(style.getColor().getForeground());
        field.setBorder(style.getBorder().getBorder());
        field.setFont(style.getFont());
    }
}

