/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.customizer.IconCustomizer;
import com.jmorgan.swing.customizer.NumberCustomizer;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.layout.EditorLayout;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.util.CustomizerFactory;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.ListNotUniqueException;
import com.jmorgan.util.collection.UniqueArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;

public class VisualComponentEditorProperties
extends JMDialog {
    private static final String[] ignoredProperties = new String[]{"action", "actionCommand", "actionListeners", "actionMap", "activator", "ancestorListeners", "backgroundAt", "caret", "changeListeners", "componentAt", "componentPopupMenu", "componentZOrder", "containerListeners", "debugGraphicsOptions", "decorator", "defaultLocale", "defaultTabComponent", "disabledIconAt", "displayedMnemonic", "displayedMnemonicIndex", "displayedMnemonicIndexAt", "document", "dragEnabled", "dropMode", "dropTarget", "doubleBuffered", "enabledAt", "focusAccelerator", "focusCycleRoot", "focusPainted", "focusTraversalKeys", "focusTraversalKeysEnabled", "focusTraversalPolicy", "foregroundSet", "focusTraversalPolicyProvider", "foregroundAt", "hideActionText", "hierarchyBoundsListeners", "highlighter", "iconAt", "ignoreRepaint", "inheritsPopupMenu", "inputMap", "inputMethodListeners", "inputVerifier", "itemListeners", "keyListeners", "keymap", "labelFor", "layout", "locale", "managingFocus", "maximumSizeSet", "minimumSizeSet", "mnemonic", "mnemonicAt", "model", "moustListeners", "moustMotionListeners", "mouseWheelListeners", "multiClickThreshhold", "navigationFilter", "nextFocusableComponent", "null", "paintingForPrint", "paintingTile", "preferredSizeSet", "print", "propertyChangeListeners", "requestFocusEnabled", "selectedComponent", "selectedIndex", "selectedIndices", "selectedValue", "selectionStart", "selectionEnd", "showing", "tabComponentAt", "tabLayoutPolicy", "titleAt", "toolTipTextAt", "transferHandler", "treeLock", "uI", "valueIsAdjusting", "verifyInputWhenFocusTarget", "vetoableChangeListeners"};
    private JComponent component;
    private DynamicBean originalProperties;
    private JMPanel editorPane;
    private EditorLayout editorLayout;
    private JMListModel<String> propertiesListModel;
    private JMList propertiesList;
    private ArrayList<String> propertyNames;
    private CustomizerFactory customizerFactory;

    public VisualComponentEditorProperties(JFrame owner, Object ... arguments) {
        super(owner, "Visual Component Editor Properties", true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        if (arguments.length > 0) {
            this.component = (JComponent)arguments[0];
        }
        this.customizerFactory = new CustomizerFactory();
        this.originalProperties = new DynamicBean();
        JSplitPane splitPane = new JSplitPane(1, new JMScrollPane(this.createPropertiesList()), this.createEditorPane());
        this.contentPane.add((Component)splitPane, "Center");
        this.contentPane.add((Component)this.createButtonPanel(), "South");
        this.setDefaultSizing(false);
        this.setDefaultCloseOperation(0);
        this.setSize(new Dimension(800, 600));
        new AsynchMethodInvoker((Object)this, "loadProperties", 650);
    }

    private JMList createPropertiesList() {
        this.propertiesListModel = new JMListModel();
        this.propertiesList = new JMList<String>((ListModel<String>)this.propertiesListModel);
        new ListSelectionEventInvoker(this.propertiesList, this, "selectedPropertyChanged");
        return this.propertiesList;
    }

    private JMPanel createEditorPane() {
        this.editorLayout = new EditorLayout();
        this.editorPane = new JMPanel(this.editorLayout);
        return this.editorPane;
    }

    private JMPanel createButtonPanel() {
        JMPanel panel = new JMPanel();
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        panel.setBorder(BorderFactory.createEtchedBorder());
        JMButton okButton = new JMButton("&OK");
        new ActionEventInvoker(okButton, this, "closeWindow", false);
        JMButton cancelButton = new JMButton("&Cancel");
        new ActionEventInvoker(cancelButton, this, "closeWindow", true);
        panel.add(okButton);
        panel.add(cancelButton);
        return panel;
    }

    @Reflected
    private void loadProperties() {
        if (this.component == null) {
            throw new IllegalStateException("The component is null in " + this.getClass().getName() + ".loadProperties()");
        }
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList();
        } else {
            this.propertyNames.clear();
        }
        ArrayList<String> propertyNames = BeanService.getPropertyNames(this.component);
        try {
            ((UniqueArrayList)propertyNames).setUniqueAssurancePolicy(false);
        }
        catch (ListNotUniqueException listNotUniqueException) {
            // empty catch block
        }
        Collections.sort(propertyNames);
        for (String propertyName : propertyNames) {
            if (Comparison.isIn(propertyName, ignoredProperties)) continue;
            this.propertyNames.add(propertyName);
            Object propertyValue = BeanService.getPropertyValue(this.component, propertyName);
            this.originalProperties.setProperty(propertyName, propertyValue);
        }
        this.propertiesListModel.addAll(this.propertyNames);
        if (this.propertyNames.size() > 0) {
            new AsynchMethodInvoker((Object)this.propertiesList, "setSelectedIndex", (Object)0, 100);
        }
    }

    @Reflected
    private void selectedPropertyChanged() {
        String propertyName = (String)this.propertiesList.getSelectedValue();
        Object propertyValue = BeanService.getPropertyValue(this.component, propertyName);
        if (propertyValue == null) {
            if (propertyName.toLowerCase().contains("name")) {
                propertyValue = "";
            } else if (propertyName.toLowerCase().contains("icon")) {
                propertyValue = new ImageIcon();
            } else if (propertyName.equals("border")) {
                propertyValue = BorderFactory.createEmptyBorder();
            } else if (propertyName.equals("bounds")) {
                propertyValue = new Rectangle(this.component.getX(), this.component.getY(), this.component.getWidth(), this.component.getHeight());
            } else if (propertyName.startsWith("alignment")) {
                propertyValue = new Float(0.0f);
            } else if (propertyName.equals("antiAliasing")) {
                propertyValue = true;
            }
        }
        if (propertyValue == null) {
            System.out.println("VisualComponentEditorProperties.selectedPropertyChanged(): " + propertyName + " is NULL... code a default");
            return;
        }
        AbstractCustomizer<?, ?> customizer = this.customizerFactory.getCustomizer(propertyValue, propertyName);
        if (this.component instanceof JTabbedPane) {
            NumericalSliderComponent editor;
            NumberCustomizer nc;
            if (propertyName.equals("tabCount")) {
                nc = (NumberCustomizer)customizer;
                editor = (NumericalSliderComponent)nc.getEditor();
                editor.getSlider().setMinimum(0);
                editor.getSlider().setMaximum(20);
            }
            if (propertyName.equals("tabPlacement")) {
                nc = (NumberCustomizer)customizer;
                editor = (NumericalSliderComponent)nc.getEditor();
                editor.getSlider().setMinimum(1);
                editor.getSlider().setMaximum(4);
            }
        }
        if (!this.editorLayout.containsCard(propertyName)) {
            MethodInvoker customizerObjectPointer = new MethodInvoker(customizer, "getObject", new Object[0]);
            new PropertyChangeInvoker(customizer, this, "setProperty", propertyName, customizerObjectPointer);
            this.editorPane.add(customizer, propertyName);
        }
        this.editorLayout.show(this.editorPane, propertyName);
    }

    public void setProperty(String propertyName, Object propertyValue) {
        System.out.println("VisualComponentEditorProperties.setProperty(propertyName=" + propertyName + ", propertyValue=" + String.valueOf(propertyValue) + ")");
        if (propertyName.equals("x") || propertyName.equals("y") || propertyName.equals("width") || propertyName.equals("height")) {
            int x = propertyName.equals("x") ? ((Integer)propertyValue).intValue() : ((Integer)BeanService.getPropertyValue(this.component, "x")).intValue();
            int y = propertyName.equals("y") ? ((Integer)propertyValue).intValue() : ((Integer)BeanService.getPropertyValue(this.component, "y")).intValue();
            int width = propertyName.equals("width") ? ((Integer)propertyValue).intValue() : ((Integer)BeanService.getPropertyValue(this.component, "width")).intValue();
            int height = propertyName.equals("height") ? ((Integer)propertyValue).intValue() : ((Integer)BeanService.getPropertyValue(this.component, "height")).intValue();
            this.component.setBounds(x, y, width, height);
        } else {
            BeanService.setPropertyValue(this.component, propertyName, propertyValue);
            if (propertyName.toLowerCase().contains("icon")) {
                IconCustomizer customizer = (IconCustomizer)this.customizerFactory.getCustomizer(propertyValue, propertyName);
                BeanService.setPropertyValue(this.component, propertyName + "Name", customizer.getIconName());
            }
        }
        this.component.invalidate();
    }

    @Reflected
    private void closeWindow(boolean restore) {
        if (restore) {
            for (String propertyName : this.propertyNames) {
                Object propertyValue = this.originalProperties.getProperty(propertyName);
                if (propertyValue == null) continue;
                try {
                    BeanService.setPropertyValue(this.component, propertyName, propertyValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        WindowCloser.closeWindow(this);
    }
}

