/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.text;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.DataTypeConverter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Pattern;

public class JSONConverter {
    private static final String[] AUTO_EXCLUSIONS = new String[]{"class", "propertyChangeSupport"};
    private HashMap<Class<?>, DataTypeConverter<?, String>> typeConverterMap;
    private HashMap<String, DataTypeConverter<?, String>> propertyConverterMap;
    private HashMap<String, Boolean> propertyFilterMap;
    private DateFormat dateFormat;

    public JSONConverter() {
        String[] stringArray = AUTO_EXCLUSIONS;
        int n = AUTO_EXCLUSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String exclusion = stringArray[n2];
            this.addPropertyFilter(exclusion, false);
            ++n2;
        }
    }

    public void addTypeConverter(Class<?> type, DataTypeConverter<?, String> converter) {
        if (this.typeConverterMap == null) {
            this.typeConverterMap = new HashMap();
        }
        this.typeConverterMap.put(type, converter);
    }

    public void addPropertyConverter(String propertyName, DataTypeConverter<?, String> converter) {
        if (this.propertyConverterMap == null) {
            this.propertyConverterMap = new HashMap();
        }
        this.propertyConverterMap.put(propertyName, converter);
    }

    public void addPropertyFilter(String propertyName, boolean inclusion) {
        if (this.propertyFilterMap == null) {
            this.propertyFilterMap = new HashMap();
        }
        this.propertyFilterMap.put(propertyName, inclusion);
    }

    public void setDateFormatter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String toJSON(Object instance) {
        StringBuilder json = new StringBuilder();
        this.encodeValue(instance, json);
        return json.toString();
    }

    private void encodeObjectValue(Object instance, StringBuilder json) {
        json.append("{");
        ArrayList<String> propertyNames = BeanService.getPropertyNames(instance);
        int i = 0;
        for (String property : propertyNames) {
            Object value;
            if (!this.isPropertyIncludedInConversion(property)) continue;
            if (property.equals("iD")) {
                property = "ID";
            }
            if ((value = BeanService.getPropertyValue(instance, property)) == null) continue;
            if (i++ > 0) {
                json.append(',');
            }
            json.append('\"');
            json.append(property);
            json.append('\"');
            json.append(':');
            this.encodeValue(value, json);
        }
        json.append("}");
    }

    private void encodeValue(Object value, StringBuilder json) {
        if (value == null) {
            json.append("null");
        } else if (value instanceof Number) {
            JSONConverter.encodeNumberValue(value, json);
        } else if (value instanceof String || value instanceof StringBuilder || value instanceof StringBuffer) {
            JSONConverter.encodeStringValue(value, json);
        } else if (value instanceof Boolean) {
            JSONConverter.encodeBooleanValue(value, json);
        } else if (value instanceof Enum) {
            JSONConverter.encodeEnumValue(value, json);
        } else if (value instanceof Collection || value instanceof Object[]) {
            this.encodeArrayValue(value, json);
        } else if (value instanceof Date || value instanceof com.jmorgan.util.Date) {
            this.encodeDateValue(value, json);
        } else {
            this.encodeObjectValue(value, json);
        }
    }

    private static void encodeNumberValue(Object value, StringBuilder json) {
        Number numberValue = (Number)value;
        if (value instanceof Double || value instanceof Float) {
            json.append(numberValue.doubleValue());
        } else {
            json.append(numberValue.intValue());
        }
    }

    private static void encodeStringValue(Object value, StringBuilder json) {
        String stringValue = value.toString();
        json.append('\"');
        json.append(stringValue);
        json.append('\"');
    }

    private static void encodeBooleanValue(Object value, StringBuilder json) {
        Boolean bool = (Boolean)value;
        json.append(bool != false ? "true" : "false");
    }

    private static void encodeEnumValue(Object value, StringBuilder json) {
        Enum enumeration = (Enum)value;
        JSONConverter.encodeStringValue(enumeration.toString(), json);
    }

    private void encodeArrayValue(Object value, StringBuilder json) {
        json.append('[');
        if (value instanceof boolean[]) {
            boolean[] blArray = (boolean[])value;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b = blArray[n2];
                JSONConverter.encodeBooleanValue(b, json);
                ++n2;
            }
        } else if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            int n = byArray.length;
            int n3 = 0;
            while (n3 < n) {
                byte b = byArray[n3];
                JSONConverter.encodeNumberValue(b, json);
                ++n3;
            }
        } else if (value instanceof short[]) {
            short[] sArray = (short[])value;
            int n = sArray.length;
            int n4 = 0;
            while (n4 < n) {
                short s = sArray[n4];
                JSONConverter.encodeNumberValue(s, json);
                ++n4;
            }
        } else if (value instanceof char[]) {
            char[] cArray = (char[])value;
            int n = cArray.length;
            int n5 = 0;
            while (n5 < n) {
                char c = cArray[n5];
                JSONConverter.encodeStringValue("" + c, json);
                ++n5;
            }
        } else if (value instanceof int[]) {
            int[] nArray = (int[])value;
            int n = nArray.length;
            int n6 = 0;
            while (n6 < n) {
                int i = nArray[n6];
                JSONConverter.encodeNumberValue(i, json);
                ++n6;
            }
        } else if (value instanceof float[]) {
            float[] fArray = (float[])value;
            int n = fArray.length;
            int n7 = 0;
            while (n7 < n) {
                float f = fArray[n7];
                JSONConverter.encodeNumberValue(Float.valueOf(f), json);
                ++n7;
            }
        } else if (value instanceof long[]) {
            long[] lArray = (long[])value;
            int n = lArray.length;
            int n8 = 0;
            while (n8 < n) {
                long l = lArray[n8];
                JSONConverter.encodeNumberValue(l, json);
                ++n8;
            }
        } else if (value instanceof double[]) {
            double[] dArray = (double[])value;
            int n = dArray.length;
            int n9 = 0;
            while (n9 < n) {
                double d = dArray[n9];
                JSONConverter.encodeNumberValue(d, json);
                ++n9;
            }
        } else if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n10 = 0;
            while (n10 < n) {
                Object v = objectArray[n10];
                this.encodeObjectValue(v, json);
                ++n10;
            }
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            int i = 0;
            for (Object cValue : c) {
                if (i++ > 0) {
                    json.append(',');
                }
                this.encodeValue(cValue, json);
            }
        }
        json.append(']');
    }

    private void encodeDateValue(Object value, StringBuilder json) {
        if (this.dateFormat == null) {
            JSONConverter.encodeStringValue(value.toString(), json);
        } else {
            JSONConverter.encodeStringValue(this.dateFormat.format((Date)value), json);
        }
    }

    private boolean isPropertyIncludedInConversion(String property) {
        boolean filter;
        if (this.propertyFilterMap == null) {
            return true;
        }
        for (String propertyPattern : this.propertyFilterMap.keySet()) {
            filter = this.propertyFilterMap.get(propertyPattern);
            if (filter || !Pattern.matches(propertyPattern, property)) continue;
            return false;
        }
        for (String propertyPattern : this.propertyFilterMap.keySet()) {
            filter = this.propertyFilterMap.get(propertyPattern);
            if (!filter || !Pattern.matches(propertyPattern, property)) continue;
            return true;
        }
        return true;
    }
}

