/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.tools;

import com.jmorgan.util.ThreadUtility;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JavaCompiler {
    private ArrayList<File> sourceFiles = new ArrayList();
    private ArrayList<Class<?>> resultClasses;

    public JavaCompiler() {
    }

    public JavaCompiler(String fileName) {
        this(new File(fileName));
    }

    public JavaCompiler(File file) {
        this();
    }

    public void addSourceFile(String fileName) {
        this.addSourceFile(new File(fileName));
    }

    public void addSourceFile(File file) {
        this.sourceFiles.add(file);
    }

    public Class<?> compile(String fileName) {
        return this.compile(new File(fileName));
    }

    public Class<?> compile(File file) {
        int currentSize = this.sourceFiles.size();
        this.sourceFiles.add(file);
        ArrayList<Class<?>> classes = this.compile();
        return classes.get(currentSize);
    }

    public ArrayList<Class<?>> compile() throws IllegalStateException {
        if (this.resultClasses != null) {
            this.resultClasses.clear();
        }
        this.resultClasses = null;
        if (this.sourceFiles.size() == 0) {
            throw new IllegalStateException("JavaCompiler.compile():  No source files available.");
        }
        javax.tools.JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(this.sourceFiles);
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, fileManager, null, null, null, compilationUnits);
        compilationTask.call();
        ThreadUtility.sleep(1000L);
        ArrayList classFiles = new ArrayList();
        try {
            URL[] dummyURLs = new URL[]{new File("").toURI().toURL()};
            URLClassLoader classLoader = URLClassLoader.newInstance(dummyURLs);
            for (File file : this.sourceFiles) {
                String fileName = file.getName();
                String className = fileName.substring(0, fileName.indexOf(46)).replace("/", ".");
                System.out.printf("JavaCompiler.compile():  File Name = [%s], Class Name = [%s]\n", fileName, className);
                Class<?> generatedClass = Class.forName(className, false, classLoader);
                classFiles.add(generatedClass);
            }
        }
        catch (MalformedURLException e) {
            classFiles.add(e.getClass());
        }
        catch (ClassNotFoundException e) {
            classFiles.add(e.getClass());
        }
        return classFiles;
    }
}

