/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.MutableInteger;
import com.jmorgan.math.Fraction;
import com.jmorgan.util.AggregatorFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CountAggregator<T>
implements AggregatorFunction<T> {
    private HashMap<T, MutableInteger> counts = new HashMap();
    private int totalCount;
    private boolean ignoreNull;

    public CountAggregator() {
        this.setIgnoreNull(false);
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public void setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getCountOf(T element) {
        MutableInteger count = this.counts.get(element);
        if (count == null) {
            return -1;
        }
        return count.getValue();
    }

    public Fraction getFrequencyOf(T element) {
        MutableInteger count = this.counts.get(element);
        if (count == null) {
            return null;
        }
        return new Fraction((long)count.getValue(), (long)this.totalCount);
    }

    public Collection<T> getElements() {
        return new ArrayList<T>(this.counts.keySet());
    }

    public Map<T, Integer> getCounts() {
        HashMap<T, Integer> counts = new HashMap<T, Integer>();
        for (T element : this.counts.keySet()) {
            counts.put(element, this.getCountOf(element));
        }
        return counts;
    }

    public Map<T, Fraction> getFrequencies() {
        HashMap<T, Fraction> freqs = new HashMap<T, Fraction>();
        for (T element : this.counts.keySet()) {
            freqs.put(element, this.getFrequencyOf(element));
        }
        return freqs;
    }

    @Override
    public void start() {
        this.counts.clear();
        this.totalCount = 0;
    }

    @Override
    public void aggregate(T value) {
        if (this.ignoreNull && value == null) {
            return;
        }
        MutableInteger count = this.counts.get(value);
        if (count == null) {
            this.counts.put(value, new MutableInteger(1));
        } else {
            count.increment();
        }
        ++this.totalCount;
    }
}

