/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.ExceptionUtility;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.DateException;
import com.jmorgan.util.DateMetaData;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Date
implements Comparable<Object>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6933896659422024901L;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    private static final String[] MONTH_NAMES = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    private static final String[] MONTH_ABRV = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    public static final SimpleDateFormat STANDARD_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    public static final SimpleDateFormat WRITING_FORMAT = new SimpleDateFormat("MMM dd, yyyy");
    public static final SimpleDateFormat LONG_FORMAT = new SimpleDateFormat("MMMM dd, yyyy");
    public static final SimpleDateFormat COMPRESSED_FORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat MILITARY_FORMAT = new SimpleDateFormat("yyyy MMM dd");
    public static final SimpleDateFormat SQL_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Pattern MMDDYYYYPattern = Pattern.compile("^([0-1]?\\d)[ /.-]?([0-3]?\\d)[ /.-]?(\\d{2,4})$");
    private static final Pattern YYYYMMDDPattern = Pattern.compile("^(\\d{2,4})[ /.-]?([0-1]?\\d)[ /.-]?([0-3]?\\d)$");
    private static final Pattern DDMMMYYYYPattern = Pattern.compile("^([0-3]?\\d),?[ /.-]?([A-Za-z]{3,9})[ /.-]?(\\d{2,4})$");
    private static final Pattern MMMDDYYYYPattern = Pattern.compile("^([A-Za-z]{3,9})([ /.\\-]*)?([0-3]?\\d)([ /\\.\\-\\\\,]*)?(\\d{2,4})$");
    private SimpleDateFormat format = STANDARD_FORMAT;
    private Calendar calendar;

    public static boolean isDate(String value) {
        try {
            new Date(value);
            return true;
        }
        catch (DateException e) {
            return false;
        }
    }

    public Date() {
        this(Calendar.getInstance());
    }

    public Date(long dateInMilliseconds) {
        this();
        this.calendar.setTimeInMillis(dateInMilliseconds);
    }

    public Date(Calendar date) {
        this.calendar = date;
    }

    public Date(int month, int day, int year) throws DateException {
        this();
        this.setDate(year, month, day);
    }

    public Date(java.util.Date date) {
        this(date.getTime());
    }

    public Date(Timestamp timestamp) {
        this(timestamp.getTime());
    }

    public Date(String date) throws DateException {
        this();
        if (this.parseStandardFormat(date)) {
            return;
        }
        if (this.parseYYYYMMDDFormat(date)) {
            return;
        }
        if (this.parseDDMMMYYYYformat(date)) {
            return;
        }
        if (this.parseMMMDDYYYYFormat(date)) {
            return;
        }
        throw new DateException("The given date " + date + " is not a date.");
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    private boolean parseStandardFormat(String date) {
        return this.parseSimplePattern(date, MMDDYYYYPattern, 3, 1, 2);
    }

    private boolean parseYYYYMMDDFormat(String date) {
        return this.parseSimplePattern(date, YYYYMMDDPattern, 1, 2, 3);
    }

    private boolean parseDDMMMYYYYformat(String date) {
        return this.parseWordedPattern(date, DDMMMYYYYPattern, 3, 2, 1);
    }

    private boolean parseMMMDDYYYYFormat(String date) {
        return this.parseWordedPattern(date, MMMDDYYYYPattern, 5, 1, 3);
    }

    private boolean parseSimplePattern(String date, Pattern pattern, int yearGroup, int monthGroup, int dayGroup) {
        String[] dateParts = Date.parsePatternedFormat(date, pattern, yearGroup, monthGroup, dayGroup);
        if (dateParts == null) {
            return false;
        }
        this.setDate(Integer.parseInt(dateParts[0]), Integer.parseInt(dateParts[1]), Integer.parseInt(dateParts[2]));
        return true;
    }

    private boolean parseWordedPattern(String date, Pattern pattern, int yearGroup, int monthGroup, int dayGroup) {
        String[] dateParts = Date.parsePatternedFormat(date, pattern, yearGroup, monthGroup, dayGroup);
        if (dateParts == null) {
            return false;
        }
        int monthNo = ArrayUtility.indexOf(dateParts[1], MONTH_ABRV) + 1;
        if (monthNo == 0 && (monthNo = ArrayUtility.indexOf(dateParts[1], MONTH_NAMES) + 1) == 0) {
            return false;
        }
        this.setDate(Integer.parseInt(dateParts[0]), monthNo, Integer.parseInt(dateParts[2]));
        return true;
    }

    private static String[] parsePatternedFormat(String date, Pattern pattern, int yearGroup, int monthGroup, int dayGroup) {
        String[] dateParts = new String[3];
        Matcher matcher = pattern.matcher(date.toLowerCase());
        boolean found = matcher.find();
        if (!found) {
            return null;
        }
        dateParts[0] = matcher.group(yearGroup);
        dateParts[1] = matcher.group(monthGroup);
        dateParts[2] = matcher.group(dayGroup);
        return dateParts;
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getWeek() {
        return this.calendar.get(3);
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getWeekDay() {
        return this.calendar.get(7);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public void setDate(Date date) throws NullPointerException {
        if (this == date) {
            return;
        }
        this.setDate(date.getYear(), date.getMonth(), date.getDay());
    }

    public void setDate(int year, int month, int day) throws DateException {
        this.setDay(1);
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public void setDate(long dateInMilliseconds) {
        this.calendar.setTimeInMillis(dateInMilliseconds);
    }

    public void setMonth(int month) throws DateException {
        if (month < 1 || month > 12) {
            throw new DateException("The given month " + month + " is invalid.");
        }
        this.calendar.set(2, month - 1);
    }

    public void setDay(int day) throws DateException {
        if (day < 1 || day > this.getDaysInMonth()) {
            throw new DateException("The given day " + day + " is invalid.");
        }
        this.calendar.set(5, day);
    }

    public void setYear(int year) {
        this.calendar.set(1, year);
    }

    public int getDaysInMonth() {
        return DateMetaData.getDaysInMonth(this);
    }

    public void addDays(int numberOfDays) {
        if (numberOfDays == 0) {
            return;
        }
        this.calendar.add(5, numberOfDays);
    }

    public void addMonths(int numberOfMonths) {
        if (numberOfMonths == 0) {
            return;
        }
        this.calendar.add(2, numberOfMonths);
    }

    public void addYears(int numberOfYears) {
        if (numberOfYears == 0) {
            return;
        }
        this.calendar.add(1, numberOfYears);
    }

    public SimpleDateFormat getFormat() {
        return this.format;
    }

    public void setFormat(SimpleDateFormat format) {
        this.format = format;
    }

    public Object clone() {
        return new Date((Calendar)this.calendar.clone());
    }

    public java.util.Date toJavaUtilDate() {
        return this.getCalendar().getTime();
    }

    public java.sql.Date toJavaSQLDate() {
        return new java.sql.Date(this.getCalendar().getTimeInMillis());
    }

    public boolean isBefore(Date that) {
        if (that == null) {
            return false;
        }
        int comparison = this.compareTo(that);
        return comparison < 0;
    }

    public boolean isAfter(Date that) {
        if (that == null) {
            return false;
        }
        int comparison = this.compareTo(that);
        return comparison > 0;
    }

    public boolean isBetween(Date start, Date end) {
        if (start == null && end == null) {
            return false;
        }
        if (start == null && (this.equals(end) || this.isBefore(end))) {
            return true;
        }
        if (end == null && (this.equals(start) || this.isAfter(start))) {
            return true;
        }
        return !(!this.equals(start) && !this.isAfter(start) || !this.isBefore(end) && !this.equals(end));
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o instanceof Date) {
            Date that = (Date)o;
            int yearCmp = this.getYear() - that.getYear();
            int monthCmp = this.getMonth() - that.getMonth();
            int dayCmp = this.getDay() - that.getDay();
            if (yearCmp == 0) {
                if (monthCmp == 0) {
                    return dayCmp;
                }
                return monthCmp;
            }
            return yearCmp;
        }
        if (o instanceof Calendar) {
            Date that = new Date((Calendar)o);
            return this.compareTo(that);
        }
        if (o instanceof java.util.Date) {
            return this.compareTo(new Date((java.util.Date)o));
        }
        if (o instanceof String) {
            try {
                Date date = new Date((String)o);
                return this.compareTo(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ExceptionUtility.throwStandardComparableException(this, o);
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getYear();
        result = 31 * result + this.getMonth();
        result = 31 * result + this.getDay();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Date) {
            Date that = (Date)o;
            return this.getYear() == that.getYear() && this.getMonth() == that.getMonth() && this.getDay() == that.getDay();
        }
        if (o instanceof Calendar) {
            Date that = new Date((Calendar)o);
            return this.equals(that);
        }
        if (o instanceof java.util.Date) {
            return this.equals(new Date((java.util.Date)o));
        }
        if (o instanceof String) {
            try {
                Date date = new Date((String)o);
                return this.equals(date);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        if (this.calendar == null) {
            return "null";
        }
        try {
            return this.format.format(this.calendar.getTime());
        }
        catch (Exception e) {
            int month = this.getMonth();
            int day = this.getDay();
            int year = this.getYear();
            String formattedDate = String.format("%02d/%02d/%04d", month, day, year);
            return formattedDate;
        }
    }
}

