/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.util.Date;
import com.jmorgan.util.DateException;
import java.util.Calendar;

public final class DateMetaData {
    public static final long SECONDS_IN_A_DAY = 86400L;
    public static final long MILLISECONDS_IN_A_DAY = 86400000L;
    public static final long MINUTES_IN_A_DAY = 1440L;
    public static final int MODE_FIRST_LETTER = 1;
    public static final int MODE_FIRST_TWO = 2;
    public static final int MODE_FIRST_THREE = 3;
    public static final int MODE_ALL = 10;
    public static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] DAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    private DateMetaData() {
    }

    public static String getDayOfWeek(Calendar date, int mode) {
        return DateMetaData.getDayOfWeek(date.get(7), mode);
    }

    public static String getDayOfWeek(Date date, int mode) {
        return DateMetaData.getDayOfWeek(date.getWeekDay(), mode);
    }

    public static String getDayOfWeek(int day, int mode) {
        return DAY_NAMES[day].substring(0, mode == 10 ? DAY_NAMES[day].length() : mode);
    }

    public static String[] getMonthNames(int mode) {
        String[] names = new String[MONTH_NAMES.length];
        int i = 0;
        while (i < names.length) {
            names[i] = MONTH_NAMES[i].substring(0, mode == 10 ? MONTH_NAMES[i].length() : mode);
            ++i;
        }
        return names;
    }

    public static String getMonthName(Calendar c, int mode) {
        return DateMetaData.getMonthName(c.get(2), mode);
    }

    public static String getMonthName(Date date, int mode) {
        return DateMetaData.getMonthName(date.getMonth() - 1, mode);
    }

    public static String getMonthName(int month, int mode) {
        return MONTH_NAMES[month].substring(0, mode == 10 ? MONTH_NAMES[month].length() : mode);
    }

    public static int getDayNumber(String day) {
        if ((day = day.toLowerCase()).equals("sunday") || day.equals("sun") || day.equals("su")) {
            return 1;
        }
        if (day.equals("monday") || day.equals("mon") || day.equals("mo")) {
            return 2;
        }
        if (day.equals("tuesday") || day.equals("tue") || day.equals("tu")) {
            return 3;
        }
        if (day.equals("wednesday") || day.equals("wed") || day.equals("we")) {
            return 4;
        }
        if (day.equals("thursday") || day.equals("thu") || day.equals("th")) {
            return 5;
        }
        if (day.equals("friday") || day.equals("fri") || day.equals("fr")) {
            return 6;
        }
        if (day.equals("saturday") || day.equals("sat") || day.equals("sa")) {
            return 7;
        }
        return -1;
    }

    public static int getMonthNumber(String month) {
        if ((month = month.toLowerCase()).equals("january") || month.equals("jan")) {
            return 0;
        }
        if (month.equals("february") || month.equals("feb")) {
            return 1;
        }
        if (month.equals("march") || month.equals("mar")) {
            return 2;
        }
        if (month.equals("april") || month.equals("apr")) {
            return 3;
        }
        if (month.equals("may") || month.equals("may")) {
            return 4;
        }
        if (month.equals("june") || month.equals("jun")) {
            return 5;
        }
        if (month.equals("july") || month.equals("jul")) {
            return 6;
        }
        if (month.equals("august") || month.equals("aug")) {
            return 7;
        }
        if (month.equals("september") || month.equals("sept")) {
            return 8;
        }
        if (month.equals("october") || month.equals("oct")) {
            return 9;
        }
        if (month.equals("november") || month.equals("nov")) {
            return 10;
        }
        if (month.equals("december") || month.equals("dec")) {
            return 11;
        }
        return -1;
    }

    public static boolean isWeekday(Calendar c) {
        switch (c.get(7)) {
            case 1: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public static boolean isWeekday(Date date) {
        switch (date.getWeekDay()) {
            case 1: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public static int getDaysInMonth(Calendar c) {
        return DateMetaData.getDaysInMonth(c.get(2), c.get(1));
    }

    public static int getDaysInMonth(Date date) {
        return DateMetaData.getDaysInMonth(date.getMonth() - 1, date.getYear());
    }

    public static int getDaysInMonth(int month, int year) throws DateException {
        int numDays = 0;
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                numDays = 31;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                numDays = 30;
                break;
            }
            case 1: {
                if (DateMetaData.isLeapYear(year)) {
                    numDays = 29;
                    break;
                }
                numDays = 28;
                break;
            }
            default: {
                throw new DateException("The month " + month + " is invalid.");
            }
        }
        return numDays;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int getDaysInYear(int year) {
        return DateMetaData.isLeapYear(year) ? 366 : 365;
    }

    public static boolean isHoliday(Calendar date) {
        if (date == null) {
            return false;
        }
        int y = date.get(1);
        int m = date.get(2);
        int dn = date.get(7);
        int d = date.get(5);
        return DateMetaData.isNewYearsDay(++m, d) || DateMetaData.isValentinesDay(m, d) || DateMetaData.isStPatricksDay(m, d) || DateMetaData.isEaster(y, m, d, dn) || DateMetaData.isMothersDay(m, d, dn) || DateMetaData.isMemorialDay(m, d, dn) || DateMetaData.isFathersDay(m, d, dn) || DateMetaData.isJulyFourth(m, d) || DateMetaData.isLaborDay(m, d, dn) || DateMetaData.isHalloween(m, d) || DateMetaData.isThanksgiving(m, d, dn) || DateMetaData.isChristmas(m, d);
    }

    public static boolean isHoliday(Date date) {
        return DateMetaData.isHoliday(date.getCalendar());
    }

    public static String getHolidayName(Calendar date) {
        if (date == null) {
            return "";
        }
        int y = date.get(1);
        int m = date.get(2);
        int dn = date.get(7);
        int d = date.get(5);
        if (DateMetaData.isNewYearsDay(++m, d)) {
            return "New Year's Day";
        }
        if (DateMetaData.isValentinesDay(m, d)) {
            return "Valentine's Day";
        }
        if (DateMetaData.isStPatricksDay(m, d)) {
            return "St. Patrick's Day";
        }
        if (DateMetaData.isEaster(y, m, d, dn)) {
            return "Easter";
        }
        if (DateMetaData.isMothersDay(m, d, dn)) {
            return "Mother's Day";
        }
        if (DateMetaData.isMemorialDay(m, d, dn)) {
            return "Memorial Day";
        }
        if (DateMetaData.isFathersDay(m, d, dn)) {
            return "Father's Day";
        }
        if (DateMetaData.isJulyFourth(m, d)) {
            return "Fourth of July";
        }
        if (DateMetaData.isLaborDay(m, d, dn)) {
            return "Labor Day";
        }
        if (DateMetaData.isHalloween(m, d)) {
            return "Halloween";
        }
        if (DateMetaData.isThanksgiving(m, d, dn)) {
            return "Thanksgiving";
        }
        if (DateMetaData.isChristmas(m, d)) {
            return "Christmas";
        }
        return "";
    }

    public static String getHolidayName(Date date) {
        return DateMetaData.getHolidayName(date.getCalendar());
    }

    private static boolean isNewYearsDay(int month, int day) {
        return month == 1 && day == 1;
    }

    private static boolean isValentinesDay(int month, int day) {
        return month == 2 && day == 14;
    }

    private static boolean isStPatricksDay(int month, int day) {
        return month == 3 && day == 17;
    }

    private static boolean isEaster(int year, int month, int day, int dayNumber) {
        if (dayNumber != 1) {
            return false;
        }
        int goldenNumber = year % 19;
        int century = year / 100;
        int gregorianEpact = (century - century / 4 - (8 * century + 13) / 25 + 19 * goldenNumber + 15) % 30;
        int days2PaschalFullMoon = gregorianEpact - gregorianEpact / 28 * (1 - 29 / (gregorianEpact + 1) * ((21 - goldenNumber) / 11));
        int weekdayOfPaschalFullMoon = (year + year / 4 + days2PaschalFullMoon + 2 - century + century / 4) % 7;
        int days2SundayOfPaschalFullMoon = days2PaschalFullMoon - weekdayOfPaschalFullMoon;
        int easterMonth = 3 + (days2SundayOfPaschalFullMoon + 40) / 44;
        int easterDay = days2SundayOfPaschalFullMoon + 28 - 31 * (easterMonth / 4);
        return month == easterMonth && day == easterDay;
    }

    private static boolean isMothersDay(int month, int day, int dayNumber) {
        return month == 5 && dayNumber == 1 && day > 7 && day - 14 < 1;
    }

    private static boolean isMemorialDay(int month, int day, int dayNumber) {
        return month == 5 && dayNumber == 2 && day + 7 > 31;
    }

    private static boolean isFathersDay(int month, int day, int dayNumber) {
        return month == 6 && dayNumber == 1 && day > 14 && day - 21 < 1;
    }

    private static boolean isJulyFourth(int month, int day) {
        return month == 7 && day == 4;
    }

    private static boolean isLaborDay(int month, int day, int dayNumber) {
        return month == 9 && dayNumber == 2 && day - 7 < 1;
    }

    private static boolean isHalloween(int month, int day) {
        return month == 10 && day == 31;
    }

    private static boolean isThanksgiving(int month, int day, int dayNumber) {
        return month == 11 && dayNumber == 5 && day > 19 && day - 28 < 1;
    }

    private static boolean isChristmas(int month, int day) {
        return month == 12 && day == 25;
    }
}

