/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.StackTrace;
import com.jmorgan.util.GenericInvocationHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;

public final class DynamicClassLoader {
    private DynamicClassLoader() {
    }

    public static Object createObjectFromClass(String className) throws NullPointerException, ClassNotFoundException, IllegalAccessException {
        if (className == null) {
            throw new NullPointerException("The given class name for DyanamicClassLoader.createObjectFromClass(String) cannot be null");
        }
        Class<?> type = DynamicClassLoader.loadClass(className);
        Object object = DynamicClassLoader.createObjectFromClass(type);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            type = Class.forName(className);
            return type;
        }
        catch (ClassNotFoundException cnfE) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    System.out.printf("DynamicClassLoader.loadClass(className=%s):  No class loader from Thread.currentThread().getContextClassLoader()\n", new Object[]{className});
                }
                type = classLoader.loadClass(className);
                return type;
            }
            catch (ClassNotFoundException cnf) {
                System.out.printf("DynamicClassLoader.loadClass(className=%s): Caught ClassNotFoundException.  Trying hierarchy.\n", new Object[]{className});
                classLoader = DynamicClassLoader.class.getClassLoader().getParent();
                ** while (classLoader != null)
            }
        }
lbl-1000:
        // 1 sources

        {
            System.out.printf("DynamicClassLoader.loadClass(className=%s): Trying to load with %s.\n", new Object[]{className, classLoader.getClass().getName()});
            try {
                type = classLoader.loadClass(className);
                return type;
            }
            catch (ClassNotFoundException clnfE) {
                System.out.printf("DynamicClassLoader.loadClass(className=%s): Caught ClassNotFoundException from loader %s.\n", new Object[]{className, classLoader.getClass().getName()});
                classLoader = classLoader.getParent();
            }
            continue;
        }
lbl28:
        // 1 sources

        System.out.printf("DynamicClassLoader.loadClass(className=%s): No more class loaders.\n", new Object[]{className});
        throw cnfE;
        catch (Exception e) {
            stackTrace = new StackTrace();
            System.out.printf("DynamicClassLoader.loadClass(className=%s):  Other exception thrown\nException: %s\n%s\n", new Object[]{className, e.getClass().getName(), StackTrace.getStackTrace(e)});
        }
        return null;
    }

    public static Object createObjectFromClass(Class<?> type) throws NullPointerException, IllegalAccessException {
        if (type == null) {
            throw new NullPointerException("The given class for DyanamicClassLoader.createObjectFromClass(Class) cannot be null");
        }
        if (type.isInterface()) {
            return DynamicClassLoader.getProxyObject(type);
        }
        if (type.isArray()) {
            return DynamicClassLoader.getPrimitiveArray(type);
        }
        if (type.isEnum()) {
            System.out.println(type.getName() + " is an enum.");
        }
        if (type.isPrimitive()) {
            return DynamicClassLoader.getPrimitive(type);
        }
        if (type.isSynthetic()) {
            System.out.println(type.getName() + " is synthetic.");
        }
        if (type.isAnnotation()) {
            System.out.println(type.getName() + " is an annotation.");
        }
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            try {
                return DynamicClassLoader.buildEasiestObject(type);
            }
            catch (Exception ee) {
                MethodInvoker instanceInvoker = new MethodInvoker(type, "getInstance", new Object[0]);
                return instanceInvoker.invoke();
            }
        }
    }

    private static Object buildEasiestObject(Class<?> type) throws Exception {
        try {
            Constructor<?> constructor = DynamicClassLoader.getLightestConstructor(type);
            constructor.setAccessible(true);
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length == 0) {
                return constructor.newInstance(new Object[]{null});
            }
            Object[] values = new Object[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i].isPrimitive()) {
                    values[i] = DynamicClassLoader.getPrimitive(parameters[i]);
                } else if (parameters[i].isArray()) {
                    values[i] = DynamicClassLoader.getPrimitiveArray(parameters[i]);
                } else if (parameters[i].isInterface()) {
                    values[i] = DynamicClassLoader.getProxyObject(parameters[i]);
                } else if (values[i] == null) {
                    values[i] = DynamicClassLoader.createObjectFromClass(parameters[i]);
                }
                ++i;
            }
            return constructor.newInstance(values);
        }
        catch (SecurityException e) {
            DynamicClassLoader.printError(type, e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            DynamicClassLoader.printError(type, e);
            throw e;
        }
        catch (InstantiationException e) {
            DynamicClassLoader.printError(type, e);
            throw e;
        }
        catch (InvocationTargetException e) {
            DynamicClassLoader.printError(type, e);
            System.err.println("The cause was:\n" + String.valueOf(e.getCause()));
            throw e;
        }
    }

    private static void printError(Class<?> type, Exception e) {
        System.err.println(e.getClass().getName() + " in DynamicClassLoader.buildEasiestObject(" + type.getName() + ")\n");
        new StackTrace(e);
    }

    private static Constructor<?> getLightestConstructor(Class<?> type) {
        int indexOfLightest = -1;
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        if (constructors.length == 1) {
            return constructors[0];
        }
        int i = 0;
        int weight = Integer.MAX_VALUE;
        while (i < constructors.length) {
            Class<?>[] parameters = constructors[i].getParameterTypes();
            if (parameters.length == 0) {
                return constructors[i];
            }
            int parmWeight = 0;
            Class<?>[] classArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> parameter = classArray[n2];
                if (parameter.isPrimitive()) {
                    ++parmWeight;
                } else if (parameter.isInterface()) {
                    parmWeight += 10;
                } else if (parameter.isAnnotation()) {
                    parmWeight += 10;
                } else if (parameter.isEnum()) {
                    System.err.println("JOE:  add code to handle enum in DynamicClassLoader.getLightestConstructor(Class)");
                } else if (parameter.isArray()) {
                    if (parameter.equals(boolean[].class) || parameter.equals(byte[].class) || parameter.equals(short[].class) || parameter.equals(char[].class) || parameter.equals(int[].class) || parameter.equals(long[].class) || parameter.equals(float[].class) || parameter.equals(double[].class)) {
                        parmWeight += 2;
                    } else if (parameter.getComponentType().isInterface()) {
                        parmWeight += 15;
                    } else if (parameter.getComponentType().isAnnotation()) {
                        parmWeight += 15;
                    } else if (parameter.getComponentType().isEnum()) {
                        System.err.println("JOE: add code the handle enum array in DynamicClassLoader.getLightestConstructor(Class)");
                    } else {
                        System.err.println("JOE:  add code to handle " + parameter.getName() + " in DynamicClassLoader.getLightestConstructor()");
                    }
                }
                ++n2;
            }
            if (parmWeight < weight) {
                weight = parmWeight;
                indexOfLightest = i;
            }
            ++i;
        }
        return constructors[indexOfLightest];
    }

    private static Object getProxyObject(Class<?> type) throws IllegalArgumentException {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("The class for DynamicClassLoader.getProxyObject(Class) is not an interface.");
        }
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, GenericInvocationHandler.getInstance());
    }

    private static Object getPrimitive(Class<?> type) {
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        if (type.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (type.equals(Short.TYPE)) {
            return (short)0;
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0L;
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return 0.0;
        }
        System.err.println("*** UNKNOWN PRIMITIVE TYPE IN DynamicClassLoader.getPrimitive(): " + type.getName());
        return null;
    }

    private static Object getPrimitiveArray(Class<?> type) {
        if (type.equals(boolean[].class)) {
            return new boolean[1];
        }
        if (type.equals(byte[].class)) {
            return new byte[1];
        }
        if (type.equals(short[].class)) {
            return new short[1];
        }
        if (type.equals(char[].class)) {
            return new char[1];
        }
        if (type.equals(int[].class)) {
            return new int[1];
        }
        if (type.equals(long[].class)) {
            return new long[1];
        }
        if (type.equals(float[].class)) {
            return new float[]{0.0f};
        }
        if (type.equals(double[].class)) {
            return new double[]{0.0};
        }
        System.err.println("*** UNKNOWN ARRAY TYPE IN DynamicClassLoader.getPrimitiveArray(): " + type.getName());
        return null;
    }
}

