/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.IdleListener;
import java.util.Vector;

public class IdleController {
    private long referenceTime = System.currentTimeMillis();
    private long warningTime;
    private long idleTime;
    private long warnAfter;
    private long idleAfter;
    private Vector<IdleListener> listeners = new Vector();
    private AsynchMethodInvoker<Void> warningInvoker;
    private AsynchMethodInvoker<Void> idleInvoker;

    public IdleController(long idleAfter) {
        this.setIdleAfter(idleAfter);
    }

    public IdleController(long warnAfter, long idleAfter) {
        this(idleAfter);
        this.setWarnAfter(warnAfter);
    }

    public long getWarnAfter() {
        return this.warnAfter;
    }

    public void setWarnAfter(long warnAfter) {
        if (warnAfter < 0L) {
            warnAfter = 0L;
        }
        this.warnAfter = warnAfter;
        this.setWarningTime();
    }

    private void setWarningTime() {
        this.stopWarningInvoker();
        if (this.warnAfter == 0L) {
            return;
        }
        this.warningTime = this.referenceTime + this.warnAfter;
        long warnNotify = this.warningTime - System.currentTimeMillis();
        this.warningInvoker = new AsynchMethodInvoker((Object)this, "sendWarningNotifications", (int)warnNotify);
    }

    private void stopWarningInvoker() {
        if (this.warningInvoker != null) {
            this.warningInvoker.cancel();
            this.warningInvoker = null;
        }
    }

    public long getIdleAfter() {
        return this.idleAfter;
    }

    public void setIdleAfter(long idleAfter) throws IllegalArgumentException {
        if (idleAfter < 1L) {
            throw new IllegalArgumentException("IdleController's idleAfter value cannot be less than 1.");
        }
        this.idleAfter = idleAfter;
        this.setIdleTime();
    }

    private void setIdleTime() {
        this.stopIdleInvoker();
        this.idleTime = this.referenceTime + this.idleAfter;
        long idleNotify = this.idleTime - System.currentTimeMillis();
        this.idleInvoker = new AsynchMethodInvoker((Object)this, "sendIdleNotifications", (int)idleNotify);
    }

    private void stopIdleInvoker() {
        if (this.idleInvoker != null) {
            this.idleInvoker.cancel();
            this.idleInvoker = null;
        }
    }

    public long getReferenceTime() {
        return this.referenceTime;
    }

    public long getRemainingTime() {
        return this.idleTime - System.currentTimeMillis();
    }

    public void update() {
        this.referenceTime = System.currentTimeMillis();
        this.setWarningTime();
        this.setIdleTime();
    }

    public void pause() {
        this.stopWarningInvoker();
        this.stopIdleInvoker();
    }

    public void addIdleListener(IdleListener idleListener) {
        if (idleListener == null) {
            return;
        }
        this.listeners.add(idleListener);
    }

    public void removeIdleListener(IdleListener idleListener) {
        if (idleListener == null) {
            return;
        }
        this.listeners.remove(idleListener);
    }

    @Reflected
    private void sendWarningNotifications() {
        for (IdleListener listener : this.listeners) {
            new AsynchMethodInvoker((Object)listener, "idleWarning");
        }
    }

    @Reflected
    private void sendIdleNotifications() {
        for (IdleListener listener : this.listeners) {
            new AsynchMethodInvoker((Object)listener, "idleTimeout");
        }
    }
}

