/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.MathExt;
import com.jmorgan.util.AggregatorFunction;
import java.util.ArrayList;

public class NumericalAggregator
implements AggregatorFunction<Number> {
    private double sum;
    private double minimum;
    private double maximum;
    private ArrayList<Double> allNumbers;
    private double variance = -1.0;
    private long count;

    public double getSum() {
        return this.sum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMean() {
        return this.getAverage();
    }

    public double getAverage() {
        return this.sum / (double)this.count;
    }

    public double getVariance() {
        if (this.variance == -1.0) {
            double[] numbers = new double[this.allNumbers.size()];
            int i = 0;
            while (i < numbers.length) {
                numbers[i] = this.allNumbers.get(i);
                ++i;
            }
            this.variance = MathExt.getVariance(numbers);
        }
        return this.variance;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public void start() {
        if (this.allNumbers != null) {
            this.allNumbers.clear();
            this.allNumbers = null;
        }
        this.allNumbers = new ArrayList();
        this.sum = 0.0;
        this.variance = -1.0;
        this.minimum = Double.MAX_VALUE;
        this.maximum = Double.MIN_VALUE;
        this.count = 0L;
    }

    @Override
    public void aggregate(Number value) {
        double number = value.doubleValue();
        this.allNumbers.add(number);
        this.sum += number;
        if (number < this.minimum) {
            this.minimum = number;
        }
        if (number > this.maximum) {
            this.maximum = number;
        }
        ++this.count;
    }
}

