/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class SystemClipboard {
    private static Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

    private SystemClipboard() {
    }

    public static String getContents() {
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void setContents(String clipContents) {
        StringSelection stringSelection = new StringSelection(clipContents);
        clipboard.setContents(stringSelection, null);
    }

    public static void clearContents() {
        SystemClipboard.setContents("");
    }

    public static void appendContents(String textToAppend) {
        String currentContents = SystemClipboard.getContents();
        SystemClipboard.setContents(currentContents + textToAppend);
    }
}

